/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.filter.ClasspathScanningSupport;
import org.junit.platform.engine.support.filter.ExclusionReasonConsumingFilter;
import org.junit.vintage.engine.discovery.ClassSelectorResolver;
import org.junit.vintage.engine.discovery.ClasspathRootSelectorResolver;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.MethodSelectorResolver;
import org.junit.vintage.engine.discovery.PackageNameSelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;
import org.junit.vintage.engine.discovery.TestClassRequest;
import org.junit.vintage.engine.discovery.TestClassRequestResolver;
import org.junit.vintage.engine.discovery.UniqueIdSelectorResolver;

@API(value=API.Usage.Internal)
public class JUnit4DiscoveryRequestResolver {
    private final EngineDescriptor engineDescriptor;
    private final Logger logger;

    public JUnit4DiscoveryRequestResolver(EngineDescriptor engineDescriptor, Logger logger) {
        this.engineDescriptor = engineDescriptor;
        this.logger = logger;
    }

    public void resolve(EngineDiscoveryRequest discoveryRequest) {
        TestClassCollector collector = this.collectTestClasses(discoveryRequest);
        Set<TestClassRequest> requests = this.filterAndConvertToTestClassRequests(discoveryRequest, collector);
        this.populateEngineDescriptor(requests);
    }

    private TestClassCollector collectTestClasses(EngineDiscoveryRequest discoveryRequest) {
        TestClassCollector collector = new TestClassCollector();
        for (DiscoverySelectorResolver<?> selectorResolver : this.getAllDiscoverySelectorResolvers(discoveryRequest)) {
            this.resolveSelectorsOfSingleType(discoveryRequest, selectorResolver, collector);
        }
        return collector;
    }

    private List<DiscoverySelectorResolver<?>> getAllDiscoverySelectorResolvers(EngineDiscoveryRequest request) {
        Predicate classNamePredicate = ClasspathScanningSupport.buildClassNamePredicate((EngineDiscoveryRequest)request);
        return Arrays.asList(new ClasspathRootSelectorResolver(classNamePredicate), new PackageNameSelectorResolver(classNamePredicate), new ClassSelectorResolver(), new MethodSelectorResolver(), new UniqueIdSelectorResolver(this.logger));
    }

    private <T extends DiscoverySelector> void resolveSelectorsOfSingleType(EngineDiscoveryRequest discoveryRequest, DiscoverySelectorResolver<T> selectorResolver, TestClassCollector collector) {
        discoveryRequest.getSelectorsByType(selectorResolver.getSelectorClass()).forEach(selector -> selectorResolver.resolve(selector, collector));
    }

    private Set<TestClassRequest> filterAndConvertToTestClassRequests(EngineDiscoveryRequest discoveryRequest, TestClassCollector collector) {
        List allClassNameFilters = discoveryRequest.getDiscoveryFiltersByType(ClassNameFilter.class);
        Filter adaptedFilter = Filter.adaptFilter((Filter)Filter.composeFilters((Collection)allClassNameFilters), Class::getName);
        ExclusionReasonConsumingFilter classFilter = new ExclusionReasonConsumingFilter(adaptedFilter, (testClass, reason) -> this.logger.fine(() -> String.format("Class %s was excluded by a class filter: %s", testClass.getName(), reason.orElse("<unknown reason>"))));
        return collector.toRequests(classFilter.toPredicate());
    }

    private void populateEngineDescriptor(Set<TestClassRequest> requests) {
        new TestClassRequestResolver((TestDescriptor)this.engineDescriptor, this.logger).populateEngineDescriptorFrom(requests);
    }
}

