/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.jetbrains.annotations.NotNull;

public abstract class DeleteUnusedElementBase<T extends XsltVariable>
extends LocalQuickFixOnPsiElement {
    private final String myName;

    protected DeleteUnusedElementBase(String name, T element) {
        super(element);
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        if ("Delete unused element" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "getFamilyName"));
        }
        return "Delete unused element";
    }

    @NotNull
    public String getText() {
        String string = "Delete unused " + this.getType() + " '" + this.myName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "invoke"));
        }
        try {
            this.deleteElement((XsltVariable)startElement);
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)((Object)((Object)this)).getClass().getName()).error((Throwable)e);
        }
    }

    public abstract String getType();

    protected void deleteElement(@NotNull T obj) throws IncorrectOperationException {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "deleteElement"));
        }
        obj.delete();
    }
}

