/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.ContextProviderExtension;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;

public abstract class XsltContextProviderExtensionBase
extends ContextProviderExtension {
    @Override
    public boolean accepts(XPathFile file) {
        PsiElement context = file.getContext();
        if (!(context instanceof XmlElement)) {
            return false;
        }
        XmlAttribute att = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        if (att == null) {
            return false;
        }
        return XsltSupport.isXPathAttribute(att) ? this.acceptsLanguage(file.getLanguage()) : false;
    }

    protected abstract boolean acceptsLanguage(Language var1);

    @Override
    @NotNull
    public ContextProvider getContextProvider(XPathFile file) {
        XmlElement xmlElement = (XmlElement)file.getContext();
        assert (xmlElement != null);
        ContextProvider contextProvider = this.create(xmlElement);
        if (contextProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderExtensionBase", "getContextProvider"));
        }
        return contextProvider;
    }

    protected abstract ContextProvider create(XmlElement var1);
}

