/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.ManifestElementType;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class ManifestParser
implements PsiParser {
    public static final TokenSet HEADER_END_TOKENS = TokenSet.create((IElementType[])new IElementType[]{ManifestTokenType.SECTION_END, ManifestTokenType.HEADER_NAME});
    private final HeaderParserRepository myRepository = (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/lang/manifest/parser/ManifestParser", "parse"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/lang/manifest/parser/ManifestParser", "parse"));
        }
        builder.setDebugMode(ApplicationManager.getApplication().isUnitTestMode());
        PsiBuilder.Marker rootMarker = builder.mark();
        while (!builder.eof()) {
            this.parseSection(builder);
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/parser/ManifestParser", "parse"));
        }
        return aSTNode;
    }

    private void parseSection(PsiBuilder builder) {
        PsiBuilder.Marker section = builder.mark();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == ManifestTokenType.HEADER_NAME) {
                this.parseHeader(builder);
                continue;
            }
            if (tokenType == ManifestTokenType.SECTION_END) {
                builder.advanceLexer();
                break;
            }
            PsiBuilder.Marker marker = builder.mark();
            ManifestParser.consumeHeaderValue(builder);
            marker.error(ManifestBundle.message("manifest.header.expected", new Object[0]));
        }
        section.done(ManifestElementType.SECTION);
    }

    private void parseHeader(PsiBuilder builder) {
        PsiBuilder.Marker header = builder.mark();
        String headerName = builder.getTokenText();
        assert (headerName != null) : "[" + builder.getOriginalText() + "]@" + builder.getCurrentOffset();
        builder.advanceLexer();
        if (builder.getTokenType() == ManifestTokenType.COLON) {
            builder.advanceLexer();
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ManifestTokenType.SIGNIFICANT_SPACE)) {
                builder.error(ManifestBundle.message("manifest.whitespace.expected", new Object[0]));
            }
            HeaderParser headerParser = (HeaderParser)ObjectUtils.notNull((Object)this.myRepository.getHeaderParser(headerName), (Object)StandardHeaderParser.INSTANCE);
            headerParser.parse(builder);
        } else {
            PsiBuilder.Marker marker = builder.mark();
            ManifestParser.consumeHeaderValue(builder);
            marker.error(ManifestBundle.message("manifest.colon.expected", new Object[0]));
        }
        header.done(ManifestElementType.HEADER);
    }

    private static void consumeHeaderValue(PsiBuilder builder) {
        while (!builder.eof() && !HEADER_END_TOKENS.contains(builder.getTokenType())) {
            builder.advanceLexer();
        }
    }
}

