/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.breakpoints.ClassFiltersField;
import com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class JavaBreakpointFiltersPanel<T extends JavaBreakpointProperties, B extends XBreakpoint<T>>
extends XBreakpointCustomPropertiesPanel<B> {
    private JPanel myConditionsPanel;
    private JCheckBox myInstanceFiltersCheckBox;
    private JPanel myInstanceFiltersFieldPanel;
    private JCheckBox myClassFiltersCheckBox;
    private ClassFiltersField myClassFiltersField;
    private JCheckBox myPassCountCheckbox;
    private JTextField myPassCountField;
    private JCheckBox myCatchCheckBox;
    private ClassFiltersField myCatchClassFilters;
    private JPanel myCatchFiltersPanel;
    private final FieldPanel myInstanceFiltersField;
    private InstanceFilter[] myInstanceFilters = InstanceFilter.EMPTY_ARRAY;
    protected final Project myProject;
    private PsiClass myBreakpointPsiClass;

    public JavaBreakpointFiltersPanel(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myInstanceFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaBreakpointFiltersPanel.this.reloadInstanceFilters();
                EditInstanceFiltersDialog _dialog = new EditInstanceFiltersDialog(JavaBreakpointFiltersPanel.this.myProject);
                _dialog.setFilters(JavaBreakpointFiltersPanel.this.myInstanceFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    JavaBreakpointFiltersPanel.access$102(JavaBreakpointFiltersPanel.this, _dialog.getFilters());
                    JavaBreakpointFiltersPanel.this.updateInstanceFilterEditor(true);
                }
            }
        }, null);
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaBreakpointFiltersPanel.this.updateCheckboxes();
            }
        };
        this.myPassCountCheckbox.addActionListener(updateListener);
        this.myInstanceFiltersCheckBox.addActionListener(updateListener);
        this.myClassFiltersCheckBox.addActionListener(updateListener);
        this.myCatchCheckBox.addActionListener(updateListener);
        ToolTipManager.sharedInstance().registerComponent(this.myInstanceFiltersField.getTextField());
        JavaBreakpointFiltersPanel.insert(this.myInstanceFiltersFieldPanel, (JComponent)this.myInstanceFiltersField);
        DebuggerUIUtil.focusEditorOnCheck(this.myPassCountCheckbox, this.myPassCountField);
        DebuggerUIUtil.focusEditorOnCheck(this.myInstanceFiltersCheckBox, this.myInstanceFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck(this.myClassFiltersCheckBox, this.myClassFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck(this.myCatchCheckBox, this.myCatchClassFilters.getTextField());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myConditionsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "getComponent"));
        }
        return jPanel;
    }

    public boolean isVisibleOnPopup(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "isVisibleOnPopup"));
        }
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            return properties.isCOUNT_FILTER_ENABLED() || properties.isCLASS_FILTERS_ENABLED() || properties.isINSTANCE_FILTERS_ENABLED() || properties instanceof JavaExceptionBreakpointProperties && ((JavaExceptionBreakpointProperties)properties).isCatchFiltersEnabled();
        }
        return false;
    }

    public void saveTo(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "saveTo"));
        }
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties == null) {
            return;
        }
        boolean changed = false;
        try {
            int filter;
            String text = this.myPassCountField.getText().trim();
            int n = filter = !text.isEmpty() ? Integer.parseInt(text) : 0;
            if (filter < 0) {
                filter = 0;
            }
            changed = properties.setCOUNT_FILTER(filter);
        }
        catch (Exception text) {
            // empty catch block
        }
        changed = properties.setCOUNT_FILTER_ENABLED(properties.getCOUNT_FILTER() > 0 && this.myPassCountCheckbox.isSelected()) || changed;
        this.reloadInstanceFilters();
        this.updateInstanceFilterEditor(true);
        if (properties instanceof JavaExceptionBreakpointProperties) {
            JavaExceptionBreakpointProperties exceptionBreakpointProperties = (JavaExceptionBreakpointProperties)properties;
            changed = exceptionBreakpointProperties.setCatchFiltersEnabled(!this.myCatchClassFilters.getText().isEmpty() && this.myCatchCheckBox.isSelected()) || changed;
            changed = exceptionBreakpointProperties.setCatchClassFilters(this.myCatchClassFilters.getClassFilters()) || changed;
            changed = exceptionBreakpointProperties.setCatchClassExclusionFilters(this.myCatchClassFilters.getClassExclusionFilters()) || changed;
        }
        changed = properties.setCLASS_FILTERS_ENABLED(!this.myClassFiltersField.getText().isEmpty() && this.myClassFiltersCheckBox.isSelected()) || changed;
        changed = properties.setClassFilters(this.myClassFiltersField.getClassFilters()) || changed;
        changed = properties.setClassExclusionFilters(this.myClassFiltersField.getClassExclusionFilters()) || changed;
        changed = properties.setINSTANCE_FILTERS_ENABLED(!this.myInstanceFiltersField.getText().isEmpty() && this.myInstanceFiltersCheckBox.isSelected()) || changed;
        boolean bl = changed = properties.setInstanceFilters(this.myInstanceFilters) || changed;
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    private static void insert(JPanel panel2, JComponent component) {
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)component, "Center");
    }

    public void loadFrom(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "loadFrom"));
        }
        this.myCatchFiltersPanel.setVisible(false);
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            if (properties.getCOUNT_FILTER() > 0) {
                this.myPassCountField.setText(Integer.toString(properties.getCOUNT_FILTER()));
            } else {
                this.myPassCountField.setText("");
            }
            this.myPassCountCheckbox.setSelected(properties.isCOUNT_FILTER_ENABLED());
            this.myInstanceFiltersCheckBox.setSelected(properties.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFilters = properties.getInstanceFilters();
            this.updateInstanceFilterEditor(true);
            this.myClassFiltersCheckBox.setSelected(properties.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.setClassFilters(properties.getClassFilters(), properties.getClassExclusionFilters());
            if (properties instanceof JavaExceptionBreakpointProperties) {
                this.myCatchFiltersPanel.setVisible(true);
                JavaExceptionBreakpointProperties exceptionBreakpointProperties = (JavaExceptionBreakpointProperties)properties;
                this.myCatchCheckBox.setSelected(exceptionBreakpointProperties.isCatchFiltersEnabled());
                this.myCatchClassFilters.setClassFilters(exceptionBreakpointProperties.getCatchClassFilters(), exceptionBreakpointProperties.getCatchClassExclusionFilters());
            }
            XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        }
        this.updateCheckboxes();
    }

    private void updateInstanceFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (!instanceFilter.isEnabled()) continue;
            filters.add(Long.toString(instanceFilter.getId()));
        }
        if (updateText) {
            this.myInstanceFiltersField.setText(StringUtil.join(filters, (String)" "));
        }
        String tipText = JavaBreakpointFiltersPanel.concatWithEx(filters, " ", (int)Math.sqrt(this.myInstanceFilters.length) + 1, "\n");
        this.myInstanceFiltersField.getTextField().setToolTipText(tipText);
    }

    private void createUIComponents() {
        this.myClassFiltersField = new ClassFiltersField(this.myProject);
        this.myCatchClassFilters = new ClassFiltersField(this.myProject);
    }

    private void reloadInstanceFilters() {
        String filtersText = this.myInstanceFiltersField.getText();
        ArrayList<InstanceFilter> idxs = new ArrayList<InstanceFilter>();
        int startNumber = -1;
        for (int i2 = 0; i2 <= filtersText.length(); ++i2) {
            if (i2 < filtersText.length() && Character.isDigit(filtersText.charAt(i2))) {
                if (startNumber != -1) continue;
                startNumber = i2;
                continue;
            }
            if (startNumber < 0) continue;
            idxs.add(InstanceFilter.create(filtersText.substring(startNumber, i2)));
            startNumber = -1;
        }
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (instanceFilter.isEnabled()) continue;
            idxs.add(instanceFilter);
        }
        this.myInstanceFilters = idxs.toArray(new InstanceFilter[idxs.size()]);
    }

    private static String concatWithEx(List<String> s, String concator, int N, String NthConcator) {
        String result2 = "";
        int i2 = 1;
        Iterator<String> iterator = s.iterator();
        while (iterator.hasNext()) {
            String str = iterator.next();
            result2 = result2 + str;
            if (iterator.hasNext()) {
                result2 = i2 % N == 0 ? result2 + NthConcator : result2 + concator;
            }
            ++i2;
        }
        return result2;
    }

    protected ClassFilter createClassConditionFilter() {
        ClassFilter classFilter = this.myBreakpointPsiClass != null ? new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return JavaBreakpointFiltersPanel.this.myBreakpointPsiClass == aClass || aClass.isInheritor(JavaBreakpointFiltersPanel.this.myBreakpointPsiClass, true);
            }
        } : null;
        return classFilter;
    }

    protected void updateCheckboxes() {
        boolean passCountApplicable = true;
        if (this.myInstanceFiltersCheckBox.isSelected() || this.myClassFiltersCheckBox.isSelected()) {
            passCountApplicable = false;
        }
        this.myPassCountCheckbox.setEnabled(passCountApplicable);
        boolean passCountSelected = this.myPassCountCheckbox.isSelected();
        this.myInstanceFiltersCheckBox.setEnabled(!passCountSelected);
        this.myClassFiltersCheckBox.setEnabled(!passCountSelected);
        this.myPassCountField.setEditable(this.myPassCountCheckbox.isSelected());
        this.myPassCountField.setEnabled(this.myPassCountCheckbox.isSelected());
        this.myInstanceFiltersField.setEnabled(this.myInstanceFiltersCheckBox.isSelected());
        this.myInstanceFiltersField.getTextField().setEditable(this.myInstanceFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEnabled(this.myClassFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEditable(this.myClassFiltersCheckBox.isSelected());
        this.myCatchClassFilters.setEnabled(this.myCatchCheckBox.isSelected());
        this.myCatchClassFilters.setEditable(this.myCatchCheckBox.isSelected());
    }

    static /* synthetic */ InstanceFilter[] access$102(JavaBreakpointFiltersPanel x0, InstanceFilter[] x1) {
        x0.myInstanceFilters = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JCheckBox jCheckBox4;
        JPanel jPanel3;
        this.createUIComponents();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConditionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(2, 2, 5, 5), -1, 7, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.conditions"), (int)0, (int)0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myInstanceFiltersCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.instance.filters"));
        jCheckBox4.setMargin(new Insets(2, 2, 0, 2));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myInstanceFiltersFieldPanel = jPanel2 = new JPanel();
        jPanel6.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.class.filters"));
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        ClassFiltersField classFiltersField = this.myClassFiltersField;
        jPanel8.add((Component)((Object)classFiltersField), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel9, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myPassCountCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.pass.count"));
        jCheckBox2.setMargin(new Insets(2, 2, 0, 2));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPassCountField = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(10);
        ((Component)jTextField).setEnabled(false);
        jPanel10.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(15, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCatchFiltersPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myCatchCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.catch.class.filters"));
        jCheckBox.setMargin(new Insets(2, 2, 0, 2));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel11.add((Component)spacer5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        ClassFiltersField classFiltersField2 = this.myCatchClassFilters;
        jPanel11.add((Component)((Object)classFiltersField2), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyTextField
    extends JTextField {
        @Override
        public String getToolTipText(MouseEvent event) {
            JavaBreakpointFiltersPanel.this.reloadInstanceFilters();
            JavaBreakpointFiltersPanel.this.updateInstanceFilterEditor(false);
            String toolTipText = super.getToolTipText(event);
            return this.getToolTipText().length() == 0 ? null : toolTipText;
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip(){
                {
                    this.setUI((ComponentUI)new MultiLineTooltipUI());
                }
            };
            toolTip.setComponent(this);
            return toolTip;
        }
    }
}

