/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBTabbedPane;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.intellij.plugins.relaxNG.convert.AdvancedDtdOptions;
import org.intellij.plugins.relaxNG.convert.AdvancedOptions;
import org.intellij.plugins.relaxNG.convert.AdvancedXsdOptions;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.jetbrains.annotations.Nullable;

public class AdvancedOptionsDialog
extends DialogWrapper {
    private AdvancedOptions myInputOptions;
    private AdvancedOptions myOutputOptions;
    private Map<String, ?> myInputOptions_;
    private Map<String, ?> myOutputOptions_;

    protected AdvancedOptionsDialog(Project project2, SchemaType inputType, SchemaType outputType) {
        super(project2, false);
        this.setTitle("Advanced Conversion Options");
        if (inputType == SchemaType.DTD) {
            this.myInputOptions = new AdvancedDtdOptions();
        }
        if (outputType == SchemaType.XSD) {
            this.myOutputOptions = new AdvancedXsdOptions();
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        Object root;
        if (this.myInputOptions != null && this.myOutputOptions != null) {
            root = new JBTabbedPane();
            ((JTabbedPane)root).addTab("Input", this.myInputOptions.getRoot());
            ((JTabbedPane)root).addTab("Output", this.myOutputOptions.getRoot());
        } else {
            root = this.myInputOptions != null ? this.myInputOptions.getRoot() : this.myOutputOptions.getRoot();
        }
        return root;
    }

    public Map<String, ?> getInputOptions() {
        if (this.myInputOptions != null) {
            return this.myInputOptions.getOptions();
        }
        return this.myInputOptions_;
    }

    public Map<String, ?> getOutputOptions() {
        if (this.myOutputOptions != null) {
            return this.myOutputOptions.getOptions();
        }
        return this.myOutputOptions_;
    }

    public void setOptions(Map<String, ?> inputOptions, Map<String, ?> outputOptions) {
        if (this.myInputOptions != null) {
            this.myInputOptions.setOptions(inputOptions);
        } else {
            this.myInputOptions_ = inputOptions;
        }
        if (this.myOutputOptions != null) {
            this.myOutputOptions.setOptions(outputOptions);
        } else {
            this.myOutputOptions_ = outputOptions;
        }
    }
}

