/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.function.Consumer;
import org.intellij.lang.regexp.AsciiUtil;

public class UnicodeCharacterNames {
    public static void iterate(Consumer<String> consumer) {
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, (String)"initNamePool", (Class[])new Class[0]);
            if (initNamePool != null) {
                byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
                int[][] lookup2d = (int[][])ReflectionUtil.getStaticFieldValue(aClass, int[][].class, (String)"lookup");
                if (lookup2d == null) {
                    return;
                }
                for (int[] indexes : lookup2d) {
                    if (indexes == null) continue;
                    for (int index : indexes) {
                        if (index == 0) continue;
                        String name = new String(namePool, index >>> 8, index & 0xFF, AsciiUtil.ASCII_CHARSET);
                        consumer.accept(name);
                    }
                }
            } else {
                Method instance = ReflectionUtil.getDeclaredMethod(aClass, (String)"getInstance", (Class[])new Class[0]);
                Field field1 = ReflectionUtil.getDeclaredField(aClass, (String)"strPool");
                Field field2 = ReflectionUtil.getDeclaredField(aClass, (String)"lookup");
                if (instance != null && field1 != null && field2 != null) {
                    int[] lookup;
                    Object characterName = instance.invoke(null, new Object[0]);
                    byte[] namePool = (byte[])field1.get(characterName);
                    for (int index : lookup = (int[])field2.get(characterName)) {
                        if (index == 0) continue;
                        String name = new String(namePool, index >>> 8, index & 0xFF, AsciiUtil.ASCII_CHARSET);
                        consumer.accept(name);
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCodePoint(String name) {
        if (name == null) {
            return -1;
        }
        Method method2 = ReflectionUtil.getMethod(Character.class, (String)"codePointOf", (Class[])new Class[]{String.class});
        if (method2 != null) {
            try {
                return (Integer)method2.invoke(null, name);
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, (String)"initNamePool", (Class[])new Class[0]);
            if (initNamePool == null) {
                return -1;
            }
            byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
            name = name.trim().toUpperCase(Locale.ROOT);
            byte[] key2 = name.getBytes(StandardCharsets.ISO_8859_1);
            int[][] lookup = (int[][])ReflectionUtil.getField(aClass, null, int[][].class, (String)"lookup");
            if (lookup == null) {
                throw new RuntimeException();
            }
            for (int i2 = 0; i2 < lookup.length; ++i2) {
                int[] indexes = lookup[i2];
                if (indexes == null) continue;
                for (int j = 0; j < indexes.length; ++j) {
                    int index = indexes[j];
                    if ((index & 0xFF) != key2.length || !UnicodeCharacterNames.matches(namePool, index >>> 8, key2)) continue;
                    return i2 << 8 | j;
                }
            }
            return UnicodeCharacterNames.getUnnamedUnicodeCharacterCodePoint(name);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getUnnamedUnicodeCharacterCodePoint(String name) {
        int index = name.lastIndexOf(32);
        if (index != -1) {
            try {
                int c = Integer.parseInt(name.substring(index + 1, name.length()), 16);
                if (Character.isValidCodePoint(c) && name.equals(Character.getName(c))) {
                    return c;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean matches(byte[] bytes, int offset, byte[] key2) {
        if (offset < 0 || offset + key2.length > bytes.length) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < key2.length; ++i2) {
            if (bytes[i2 + offset] == key2[i2]) continue;
            return false;
        }
        return true;
    }
}

