/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.impl;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PsiActionSupportFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.impl.ThumbnailViewImpl;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ImageComponentDecorator;
import org.intellij.images.ui.ThumbnailComponent;
import org.intellij.images.ui.ThumbnailComponentUI;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ThumbnailViewUI
extends JPanel
implements DataProvider,
Disposable {
    private final VirtualFileListener vfsListener = new VFSListener();
    private final OptionsChangeListener optionsListener = new OptionsChangeListener();
    private static final Navigatable[] EMPTY_NAVIGATABLE_ARRAY = new Navigatable[0];
    private final ThumbnailView thumbnailView;
    private final CopyPasteSupport copyPasteSupport;
    private final DeleteProvider deleteProvider;
    private ThumbnailListCellRenderer cellRenderer;
    private JList list;
    private static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = (o1, o2) -> {
        if (o1.isDirectory() && !o2.isDirectory()) {
            return -1;
        }
        if (o2.isDirectory() && !o1.isDirectory()) {
            return 1;
        }
        return o1.getPath().toLowerCase().compareTo(o2.getPath().toLowerCase());
    };

    public ThumbnailViewUI(ThumbnailViewImpl thumbnailView) {
        super(new BorderLayout());
        this.thumbnailView = thumbnailView;
        PsiActionSupportFactory factory = PsiActionSupportFactory.getInstance();
        this.copyPasteSupport = factory.createPsiBasedCopyPasteSupport(thumbnailView.getProject(), (JComponent)this, new PsiActionSupportFactory.PsiElementSelector(){

            public PsiElement[] getSelectedElements() {
                return (PsiElement[])ThumbnailViewUI.this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
            }
        });
        this.deleteProvider = factory.createPsiBasedDeleteProvider();
    }

    private void createUI() {
        if (this.cellRenderer == null || this.list == null) {
            this.cellRenderer = new ThumbnailListCellRenderer();
            ImageComponent imageComponent = this.cellRenderer.getImageComponent();
            VirtualFileManager.getInstance().addVirtualFileListener(this.vfsListener);
            Options options = OptionsManager.getInstance().getOptions();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            imageComponent.setTransparencyChessboardVisible(chessboardOptions.isShowDefault());
            imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            options.addPropertyChangeListener(this.optionsListener);
            this.list = new JBList();
            this.list.setModel(new DefaultListModel());
            this.list.setLayoutOrientation(2);
            this.list.setVisibleRowCount(-1);
            this.list.setCellRenderer(this.cellRenderer);
            this.list.setSelectionMode(2);
            ThumbnailsMouseAdapter mouseListener = new ThumbnailsMouseAdapter();
            this.list.addMouseListener(mouseListener);
            this.list.addMouseMotionListener(mouseListener);
            ThumbnailComponentUI componentUI = (ThumbnailComponentUI)UIManager.getUI(this.cellRenderer);
            Dimension preferredSize = componentUI.getPreferredSize(this.cellRenderer);
            this.list.setFixedCellWidth(preferredSize.width);
            this.list.setFixedCellHeight(preferredSize.height);
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.list, (int)20, (int)31);
            scrollPane.setBorder(IdeBorderFactory.createBorder((int)2));
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.ThumbnailsToolbar");
            ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Thumbnails", actionGroup, true);
            actionToolbar.setTargetComponent((JComponent)this);
            JComponent toolbar = actionToolbar.getComponent();
            FocusRequester focusRequester = new FocusRequester();
            toolbar.addMouseListener(focusRequester);
            scrollPane.addMouseListener(focusRequester);
            this.add((Component)toolbar, "North");
            this.add((Component)scrollPane, "Center");
        }
    }

    public void refresh() {
        this.createUI();
        if (this.list != null) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            model.clear();
            VirtualFile root = this.thumbnailView.getRoot();
            if (root != null && root.isValid() && root.isDirectory()) {
                Set<VirtualFile> files = this.findFiles(root.getChildren());
                VirtualFile[] virtualFiles = VfsUtil.toVirtualFileArray(files);
                Arrays.sort(virtualFiles, VIRTUAL_FILE_COMPARATOR);
                model.ensureCapacity(model.size() + virtualFiles.length + 1);
                for (VirtualFile virtualFile : virtualFiles) {
                    model.addElement(virtualFile);
                }
                if (model.size() > 0) {
                    this.list.setSelectedIndex(0);
                }
            } else {
                this.thumbnailView.setVisible(false);
            }
        }
    }

    public boolean isTransparencyChessboardVisible() {
        this.createUI();
        return this.cellRenderer.getImageComponent().isTransparencyChessboardVisible();
    }

    public void setTransparencyChessboardVisible(boolean visible) {
        this.createUI();
        this.cellRenderer.getImageComponent().setTransparencyChessboardVisible(visible);
        this.list.repaint();
    }

    public void setSelected(VirtualFile file2, boolean selected) {
        this.createUI();
        this.list.setSelectedValue(file2, false);
    }

    public void scrollToSelection() {
        int minSelectionIndex = this.list.getMinSelectionIndex();
        int maxSelectionIndex = this.list.getMaxSelectionIndex();
        if (minSelectionIndex != -1 && maxSelectionIndex != -1) {
            this.list.scrollRectToVisible(this.list.getCellBounds(minSelectionIndex, maxSelectionIndex));
        }
    }

    public boolean isSelected(VirtualFile file2) {
        int index = ((DefaultListModel)this.list.getModel()).indexOf(file2);
        return index != -1 && this.list.isSelectedIndex(index);
    }

    @NotNull
    public VirtualFile[] getSelection() {
        Object[] selectedValues;
        if (this.list != null && (selectedValues = this.list.getSelectedValues()) != null) {
            VirtualFile[] files = new VirtualFile[selectedValues.length];
            for (int i2 = 0; i2 < selectedValues.length; ++i2) {
                files[i2] = (VirtualFile)selectedValues[i2];
            }
            if (files == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/impl/ThumbnailViewUI", "getSelection"));
            }
            return files;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/impl/ThumbnailViewUI", "getSelection"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private Set<VirtualFile> findFiles(VirtualFile[] roots) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            files.addAll(this.findFiles(root));
        }
        return files;
    }

    private Set<VirtualFile> findFiles(VirtualFile file2) {
        ProjectRootManager rootManager;
        boolean projectIgnored;
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(0);
        Project project2 = this.thumbnailView.getProject();
        if (!(project2.isDisposed() || (projectIgnored = (rootManager = ProjectRootManager.getInstance((Project)project2)).getFileIndex().isExcluded(file2)) || FileTypeManager.getInstance().isFileIgnored(file2))) {
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            if (file2.isDirectory()) {
                if (this.thumbnailView.isRecursive()) {
                    files.addAll(this.findFiles(file2.getChildren()));
                } else if (this.isImagesInDirectory(file2)) {
                    files.add(file2);
                }
            } else if (typeManager.isImage(file2)) {
                files.add(file2);
            }
        }
        return files;
    }

    private boolean isImagesInDirectory(VirtualFile dir) {
        VirtualFile[] files;
        ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
        for (VirtualFile file2 : files = dir.getChildren()) {
            if (file2.isDirectory()) {
                return true;
            }
            if (!typeManager.isImage(file2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.thumbnailView.getProject();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            return selectedFiles.length > 0 ? selectedFiles[0] : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedFiles();
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            return this.getData(CommonDataKeys.PSI_ELEMENT.getName());
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            return selectedFiles.length > 0 ? PsiManager.getInstance((Project)this.thumbnailView.getProject()).findFile(selectedFiles[0]) : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return this.getSelectedElements();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            return new ThumbnailNavigatable(selectedFiles.length > 0 ? selectedFiles[0] : null);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.copyPasteSupport.getCopyProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.copyPasteSupport.getCutProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.copyPasteSupport.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.deleteProvider;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            HashSet<ThumbnailNavigatable> navigatables = new HashSet<ThumbnailNavigatable>(selectedFiles.length);
            for (VirtualFile selectedFile : selectedFiles) {
                if (selectedFile.isDirectory()) continue;
                navigatables.add(new ThumbnailNavigatable(selectedFile));
            }
            return navigatables.toArray(EMPTY_NAVIGATABLE_ARRAY);
        }
        if (ThumbnailView.DATA_KEY.is(dataId)) {
            return this.thumbnailView;
        }
        if (ImageComponentDecorator.DATA_KEY.is(dataId)) {
            return this.thumbnailView;
        }
        return null;
    }

    @NotNull
    private PsiElement[] getSelectedElements() {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        HashSet<PsiFile> psiElements = new HashSet<PsiFile>(selectedFiles.length);
        PsiManager psiManager = PsiManager.getInstance((Project)this.thumbnailView.getProject());
        for (VirtualFile file2 : selectedFiles) {
            PsiFile element;
            PsiFile psiFile = psiManager.findFile(file2);
            Object object = element = psiFile != null ? psiFile : psiManager.findDirectory(file2);
            if (element == null) continue;
            psiElements.add(element);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(psiElements);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/impl/ThumbnailViewUI", "getSelectedElements"));
        }
        return psiElementArray;
    }

    @NotNull
    private VirtualFile[] getSelectedFiles() {
        Object[] selectedValues;
        if (this.list != null && (selectedValues = this.list.getSelectedValues()) != null) {
            VirtualFile[] files = new VirtualFile[selectedValues.length];
            for (int i2 = 0; i2 < selectedValues.length; ++i2) {
                files[i2] = (VirtualFile)selectedValues[i2];
            }
            if (files == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/impl/ThumbnailViewUI", "getSelectedFiles"));
            }
            return files;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/impl/ThumbnailViewUI", "getSelectedFiles"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public void dispose() {
        this.removeAll();
        Options options = OptionsManager.getInstance().getOptions();
        options.removePropertyChangeListener(this.optionsListener);
        VirtualFileManager.getInstance().removeVirtualFileListener(this.vfsListener);
        this.list = null;
        this.cellRenderer = null;
    }

    private class FocusRequester
    extends MouseAdapter {
        private FocusRequester() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ThumbnailViewUI.this.requestFocus();
        }
    }

    private final class OptionsChangeListener
    implements PropertyChangeListener {
        private OptionsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Options options = (Options)evt.getSource();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            GridOptions gridOptions = editorOptions.getGridOptions();
            ImageComponent imageComponent = ThumbnailViewUI.this.cellRenderer.getImageComponent();
            imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
            imageComponent.setGridLineSpan(gridOptions.getLineSpan());
            imageComponent.setGridLineColor(gridOptions.getLineColor());
        }
    }

    private final class VFSListener
    extends VirtualFileAdapter {
        private VFSListener() {
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            int index;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/thumbnail/impl/ThumbnailViewUI$VFSListener", "contentsChanged"));
            }
            VirtualFile file2 = event.getFile();
            if (ThumbnailViewUI.this.list != null && (index = ((DefaultListModel)ThumbnailViewUI.this.list.getModel()).indexOf(file2)) != -1) {
                Rectangle cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index);
                ThumbnailViewUI.this.list.repaint(cellBounds);
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/thumbnail/impl/ThumbnailViewUI$VFSListener", "fileDeleted"));
            }
            VirtualFile file2 = event.getFile();
            VirtualFile root = ThumbnailViewUI.this.thumbnailView.getRoot();
            if (root != null && VfsUtil.isAncestor((VirtualFile)file2, (VirtualFile)root, (boolean)false)) {
                ThumbnailViewUI.this.refresh();
            }
            if (ThumbnailViewUI.this.list != null) {
                ((DefaultListModel)ThumbnailViewUI.this.list.getModel()).removeElement(file2);
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/thumbnail/impl/ThumbnailViewUI$VFSListener", "propertyChanged"));
            }
            ThumbnailViewUI.this.refresh();
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/thumbnail/impl/ThumbnailViewUI$VFSListener", "fileCreated"));
            }
            ThumbnailViewUI.this.refresh();
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/thumbnail/impl/ThumbnailViewUI$VFSListener", "fileMoved"));
            }
            ThumbnailViewUI.this.refresh();
        }
    }

    private final class ThumbnailNavigatable
    implements Navigatable {
        private final VirtualFile file;

        public ThumbnailNavigatable(VirtualFile file2) {
            this.file = file2;
        }

        public void navigate(boolean requestFocus) {
            if (this.file != null) {
                FileEditorManager manager = FileEditorManager.getInstance((Project)ThumbnailViewUI.this.thumbnailView.getProject());
                manager.openFile(this.file, true);
            }
        }

        public boolean canNavigate() {
            return this.file != null;
        }

        public boolean canNavigateToSource() {
            return this.file != null;
        }
    }

    private final class ThumbnailsMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private ThumbnailsMouseAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Rectangle cellBounds;
            Point point = e.getPoint();
            int index = ThumbnailViewUI.this.list.locationToIndex(point);
            if (index != -1 && !(cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index)).contains(point) && (0x80 & e.getModifiersEx()) != 128) {
                ThumbnailViewUI.this.list.clearSelection();
                e.consume();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle cellBounds;
            Point point = e.getPoint();
            int index = ThumbnailViewUI.this.list.locationToIndex(point);
            if (index != -1 && !(cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index)).contains(point) && (0x80 & e.getModifiersEx()) != 128) {
                ThumbnailViewUI.this.list.clearSelection();
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Rectangle cellBounds;
            Point point = e.getPoint();
            int index = ThumbnailViewUI.this.list.locationToIndex(point);
            if (index != -1 && !(cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index)).contains(point) && (0x80 & e.getModifiersEx()) != 128) {
                index = -1;
                ThumbnailViewUI.this.list.clearSelection();
            }
            if (index != -1) {
                if (1 == e.getButton() && e.getClickCount() == 2) {
                    ThumbnailViewUI.this.list.setSelectedIndex(index);
                    VirtualFile selected = (VirtualFile)ThumbnailViewUI.this.list.getSelectedValue();
                    if (selected != null) {
                        if (selected.isDirectory()) {
                            ThumbnailViewUI.this.thumbnailView.setRoot(selected);
                        } else {
                            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)ThumbnailViewUI.this.thumbnailView.getProject());
                            fileEditorManager.openFile(selected, true);
                        }
                        e.consume();
                    }
                }
                if (3 == e.getButton() && e.getClickCount() == 1) {
                    if ((0x80 & e.getModifiersEx()) != 128) {
                        ThumbnailViewUI.this.list.setSelectedIndex(index);
                    } else {
                        ThumbnailViewUI.this.list.getSelectionModel().addSelectionInterval(index, index);
                    }
                    ActionManager actionManager = ActionManager.getInstance();
                    ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.ThumbnailsPopupMenu");
                    ActionPopupMenu menu = actionManager.createActionPopupMenu("Images.Thumbnails", actionGroup);
                    JPopupMenu popupMenu = menu.getComponent();
                    popupMenu.pack();
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }
        }
    }

    private final class ThumbnailListCellRenderer
    extends ThumbnailComponent
    implements ListCellRenderer {
        private final ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();

        private ThumbnailListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof VirtualFile) {
                VirtualFile file2 = (VirtualFile)value;
                this.setFileName(file2.getName());
                this.setToolTipText(IfsUtil.getReferencePath(ThumbnailViewUI.this.thumbnailView.getProject(), file2));
                this.setDirectory(file2.isDirectory());
                if (file2.isDirectory()) {
                    VirtualFile child;
                    VirtualFile[] children2;
                    int imagesCount = 0;
                    VirtualFile[] virtualFileArray = children2 = file2.getChildren();
                    int n = virtualFileArray.length;
                    for (int j = 0; !(j >= n || this.typeManager.isImage(child = virtualFileArray[j]) && ++imagesCount > 100); ++j) {
                    }
                    this.setImagesCount(imagesCount);
                } else {
                    this.setFileSize(file2.getLength());
                    try {
                        BufferedImage image = IfsUtil.getImage(file2);
                        ImageComponent imageComponent = this.getImageComponent();
                        imageComponent.getDocument().setValue(image);
                        this.setFormat(IfsUtil.getFormat(file2));
                    }
                    catch (Exception e) {
                        ImageComponent imageComponent = this.getImageComponent();
                        imageComponent.getDocument().setValue(null);
                    }
                }
            } else {
                ImageComponent imageComponent = this.getImageComponent();
                imageComponent.getDocument().setValue(null);
                this.setFileName(null);
                this.setFileSize(0L);
                this.setToolTipText(null);
            }
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }
}

