/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.asm.;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.MethodInfoTransformer;
import net.sf.cglib.core.MethodWrapper;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.RejectModifierPredicate;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.Transformer;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.BridgeMethodGenerator;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackGenerator;
import net.sf.cglib.proxy.CallbackInfo;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;

public class AdvancedEnhancer
extends AbstractClassGenerator {
    private static final CallbackFilter ALL_ZERO = new CallbackFilter(){

        public int accept(Method method2) {
            return 0;
        }
    };
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(Enhancer.class.getName());
    private static final EnhancerKey KEY_FACTORY = (EnhancerKey)KeyFactory.create(EnhancerKey.class);
    private static final String BOUND_FIELD = "CGLIB$BOUND";
    private static final String THREAD_CALLBACKS_FIELD = "CGLIB$THREAD_CALLBACKS";
    private static final String STATIC_CALLBACKS_FIELD = "CGLIB$STATIC_CALLBACKS";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final String SET_STATIC_CALLBACKS_NAME = "CGLIB$SET_STATIC_CALLBACKS";
    private static final String CONSTRUCTED_FIELD = "CGLIB$CONSTRUCTED";
    private static final .Type FACTORY = TypeUtils.parseType((String)"net.sf.cglib.proxy.Factory");
    private static final .Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType((String)"IllegalStateException");
    private static final .Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType((String)"IllegalArgumentException");
    private static final .Type THREAD_LOCAL = TypeUtils.parseType((String)"ThreadLocal");
    private static final .Type CALLBACK = TypeUtils.parseType((String)"net.sf.cglib.proxy.Callback");
    private static final .Type CALLBACK_ARRAY = .Type.getType(Callback[].class);
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor((String)"");
    private static final Signature SET_THREAD_CALLBACKS = new Signature("CGLIB$SET_THREAD_CALLBACKS", .Type.VOID_TYPE, new .Type[]{CALLBACK_ARRAY});
    private static final Signature SET_STATIC_CALLBACKS = new Signature("CGLIB$SET_STATIC_CALLBACKS", .Type.VOID_TYPE, new .Type[]{CALLBACK_ARRAY});
    private static final Signature NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new .Type[]{CALLBACK_ARRAY});
    private static final Signature MULTIARG_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new .Type[]{Constants.TYPE_CLASS_ARRAY, Constants.TYPE_OBJECT_ARRAY, CALLBACK_ARRAY});
    private static final Signature SINGLE_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new .Type[]{CALLBACK});
    private static final Signature SET_CALLBACK = new Signature("setCallback", .Type.VOID_TYPE, new .Type[]{.Type.INT_TYPE, CALLBACK});
    private static final Signature GET_CALLBACK = new Signature("getCallback", CALLBACK, new .Type[]{.Type.INT_TYPE});
    private static final Signature SET_CALLBACKS = new Signature("setCallbacks", .Type.VOID_TYPE, new .Type[]{CALLBACK_ARRAY});
    private static final Signature GET_CALLBACKS = new Signature("getCallbacks", CALLBACK_ARRAY, new .Type[0]);
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature((String)"Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature((String)"void set(Object)");
    private static final Signature BIND_CALLBACKS = TypeUtils.parseSignature((String)"void CGLIB$BIND_CALLBACKS(Object)");
    private static final DefaultNamingPolicy JETBRAINS_NAMING_POLICY = new DefaultNamingPolicy(){

        protected String getTag() {
            return "ByJetBrainsMainCglib";
        }
    };
    private Class[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private .Type[] callbackTypes;
    private boolean classOnly;
    private Class superclass;
    private Class[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    private Long serialVersionUID;
    private boolean interceptDuringConstruction = true;

    public AdvancedEnhancer() {
        super(SOURCE);
        this.setNamingPolicy((NamingPolicy)JETBRAINS_NAMING_POLICY);
    }

    public void setSuperclass(Class superclass) {
        if (superclass != null && superclass.isInterface()) {
            this.setInterfaces(new Class[]{superclass});
        } else {
            this.superclass = superclass != null && superclass.equals(Object.class) ? null : superclass;
        }
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(new Callback[]{callback});
    }

    public void setCallbacks(Callback[] callbacks) {
        if (callbacks != null && callbacks.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbacks;
    }

    public void setUseFactory(boolean useFactory) {
        this.useFactory = useFactory;
    }

    public void setInterceptDuringConstruction(boolean interceptDuringConstruction) {
        this.interceptDuringConstruction = interceptDuringConstruction;
    }

    public void setCallbackTypes(Class[] callbackTypes) {
        if (callbackTypes != null && callbackTypes.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = CallbackInfo.determineTypes((Class[])callbackTypes);
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Class[] argumentTypes, Object[] arguments) {
        this.classOnly = false;
        if (argumentTypes == null || arguments == null || argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        AdvancedEnhancer advancedEnhancer = this;
        synchronized (advancedEnhancer) {
            Object object;
            this.argumentTypes = argumentTypes;
            this.arguments = arguments;
            try {
                object = this.createHelper();
                this.arguments = null;
            }
            catch (Throwable throwable) {
                this.arguments = null;
                throw throwable;
            }
            return object;
        }
    }

    private void validate() {
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("Callbacks are required");
        }
        if (this.classOnly && this.callbackTypes == null) {
            throw new IllegalStateException("Callback types are required");
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            .Type[] check = CallbackInfo.determineTypes((Callback[])this.callbacks);
            for (int i2 = 0; i2 < check.length; ++i2) {
                if (check[i2].equals((Object)this.callbackTypes[i2])) continue;
                throw new IllegalStateException("Callback " + check[i2] + " is not assignable to " + this.callbackTypes[i2]);
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = CallbackInfo.determineTypes((Callback[])this.callbacks);
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = ALL_ZERO;
        }
        if (this.interfaces != null) {
            for (Class anInterface : this.interfaces) {
                if (anInterface == null) {
                    throw new IllegalStateException("Interfaces cannot be null");
                }
                if (anInterface.isInterface()) continue;
                throw new IllegalStateException(anInterface + " is not an interface");
            }
        }
    }

    private Object createHelper() {
        this.validate();
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[ReflectUtils.findPackageProtected((Class[])this.interfaces)].getName());
        }
        return super.create(KEY_FACTORY.newInstance(this.superclass != null ? this.superclass.getName() : null, ReflectUtils.getNames((Class[])this.interfaces), this.filter, this.callbackTypes, this.useFactory, this.interceptDuringConstruction, this.serialVersionUID));
    }

    protected ClassLoader getDefaultClassLoader() {
        int maxIndex = -1;
        ClassLoader bestLoader = null;
        ClassLoader nonPluginLoader = null;
        if (this.interfaces != null && this.interfaces.length > 0) {
            for (Class anInterface : this.interfaces) {
                ClassLoader loader = anInterface.getClassLoader();
                if (loader instanceof PluginClassLoader) {
                    int order = PluginManagerCore.getPluginLoadingOrder(((PluginClassLoader)((Object)loader)).getPluginId());
                    if (maxIndex >= order) continue;
                    maxIndex = order;
                    bestLoader = loader;
                    continue;
                }
                if (nonPluginLoader != null) continue;
                nonPluginLoader = loader;
            }
        }
        ClassLoader superLoader = null;
        if (this.superclass != null && (superLoader = this.superclass.getClassLoader()) instanceof PluginClassLoader && maxIndex < PluginManagerCore.getPluginLoadingOrder(((PluginClassLoader)((Object)superLoader)).getPluginId())) {
            return superLoader;
        }
        if (bestLoader != null) {
            return bestLoader;
        }
        return superLoader == null ? nonPluginLoader : superLoader;
    }

    private static Signature rename(Signature sig, int index) {
        return new Signature("CGLIB$" + sig.getName() + "$" + index, sig.getDescriptor());
    }

    private static void getMethods(Class superclass, Class[] interfaces, List<Method> methods, List<Method> interfaceMethods, Set forcePublic) {
        List<Method> target;
        ReflectUtils.addAllMethods((Class)superclass, methods);
        List<Method> list = target = interfaceMethods != null ? interfaceMethods : methods;
        if (interfaces != null) {
            for (Class anInterface : interfaces) {
                if (anInterface == Factory.class) continue;
                ReflectUtils.addAllMethods((Class)anInterface, target);
            }
        }
        if (interfaceMethods != null) {
            if (forcePublic != null) {
                forcePublic.addAll(MethodWrapper.createSet(interfaceMethods));
            }
            methods.addAll(interfaceMethods);
        }
        CollectionUtils.filter(methods, (Predicate)new DuplicatesPredicate());
        CollectionUtils.filter(methods, (Predicate)new RejectModifierPredicate(24));
        CollectionUtils.filter(methods, (Predicate)new VisibilityPredicate(superclass, true));
    }

    public void generateClass(.ClassVisitor v) throws Exception {
        Class sc;
        Class clazz = sc = this.superclass == null ? Object.class : this.superclass;
        if (TypeUtils.isFinal((int)sc.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + sc);
        }
        ArrayList<Constructor> constructors = new ArrayList<Constructor>(Arrays.asList(sc.getDeclaredConstructors()));
        this.filterConstructors(sc, constructors);
        HashSet forcePublic = new HashSet();
        ArrayList<Method> actualMethods = new ArrayList<Method>();
        HashMap<Method, Method> covariantMethods = new HashMap<Method, Method>();
        AdvancedEnhancer.getMethods(sc, this.interfaces, actualMethods, new ArrayList<Method>(), forcePublic);
        for (Class aClass = sc; aClass != null; aClass = aClass.getSuperclass()) {
            for (Method method2 : aClass.getDeclaredMethods()) {
                if (!actualMethods.contains(method2)) continue;
                AdvancedEnhancer.removeAllCovariantMethods(actualMethods, method2, covariantMethods);
            }
        }
        ClassEmitter e = new ClassEmitter(v);
        e.begin_class(46, 1, this.getClassName(), .Type.getType((Class)sc), this.useFactory ? TypeUtils.add((.Type[])TypeUtils.getTypes((Class[])this.interfaces), (.Type)FACTORY) : TypeUtils.getTypes((Class[])this.interfaces), "<generated>");
        List constructorInfo = CollectionUtils.transform(constructors, (Transformer)MethodInfoTransformer.getInstance());
        e.declare_field(2, BOUND_FIELD, .Type.BOOLEAN_TYPE, null);
        if (!this.interceptDuringConstruction) {
            e.declare_field(2, CONSTRUCTED_FIELD, .Type.BOOLEAN_TYPE, null);
        }
        e.declare_field(26, THREAD_CALLBACKS_FIELD, THREAD_LOCAL, null);
        e.declare_field(26, STATIC_CALLBACKS_FIELD, CALLBACK_ARRAY, null);
        if (this.serialVersionUID != null) {
            e.declare_field(26, "serialVersionUID", .Type.LONG_TYPE, (Object)this.serialVersionUID);
        }
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            e.declare_field(2, AdvancedEnhancer.getCallbackField(i2), this.callbackTypes[i2], null);
        }
        HashMap<Method, MethodInfo> methodInfoMap = new HashMap<Method, MethodInfo>();
        for (Method method2 : actualMethods) {
            if (AdvancedEnhancer.isJdk8DefaultMethod(method2)) continue;
            int modifiers = 0x10 | method2.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
            if (forcePublic.contains(MethodWrapper.create((Method)method2))) {
                modifiers = modifiers & 0xFFFFFFFB | 1;
            }
            if (covariantMethods.containsKey(method2)) {
                modifiers |= 0x40;
            }
            methodInfoMap.put(method2, ReflectUtils.getMethodInfo((Member)method2, (int)modifiers));
        }
        this.emitMethods(e, methodInfoMap, covariantMethods);
        this.emitConstructors(e, constructorInfo);
        AdvancedEnhancer.emitSetThreadCallbacks(e);
        AdvancedEnhancer.emitSetStaticCallbacks(e);
        this.emitBindCallbacks(e);
        if (this.useFactory) {
            int[] keys = this.getCallbackKeys();
            AdvancedEnhancer.emitNewInstanceCallbacks(e);
            this.emitNewInstanceCallback(e);
            AdvancedEnhancer.emitNewInstanceMultiarg(e, constructorInfo);
            AdvancedEnhancer.emitGetCallback(e, keys);
            this.emitSetCallback(e, keys);
            this.emitGetCallbacks(e);
            this.emitSetCallbacks(e);
        }
        e.end_class();
    }

    private static boolean isJdk8DefaultMethod(Method method2) {
        return (method2.getModifiers() & 0x409) == 1 && method2.getDeclaringClass().isInterface();
    }

    private static void removeAllCovariantMethods(List<Method> actualMethods, Method method2, Map<Method, Method> covariantMethods) {
        if ((method2.getModifiers() & 0x1000) != 0) {
            return;
        }
        Iterator<Method> it = actualMethods.iterator();
        while (it.hasNext()) {
            Method actualMethod = it.next();
            if (actualMethod.equals(method2) || !actualMethod.getName().equals(method2.getName()) || !Arrays.equals(actualMethod.getParameterTypes(), method2.getParameterTypes()) || !ReflectionUtil.isAssignable(actualMethod.getReturnType(), method2.getReturnType())) continue;
            if ((actualMethod.getModifiers() & 0x400) != 0 || (actualMethod.getModifiers() & 0x1000) != 0) {
                covariantMethods.put(actualMethod, method2);
                continue;
            }
            it.remove();
        }
    }

    protected void filterConstructors(Class sc, List<Constructor> constructors) {
        CollectionUtils.filter(constructors, (Predicate)new VisibilityPredicate(sc, true));
        if (constructors.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + sc);
        }
    }

    protected Object firstInstance(Class type) throws Exception {
        if (this.classOnly) {
            return type;
        }
        return this.createUsingReflection(type);
    }

    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        if (instance instanceof Factory) {
            if (this.argumentTypes != null) {
                return ((Factory)instance).newInstance(this.argumentTypes, this.arguments, this.callbacks);
            }
            return ((Factory)instance).newInstance(this.callbacks);
        }
        return this.createUsingReflection(protoclass);
    }

    private static void setThreadCallbacks(Class type, Callback[] callbacks) {
        AdvancedEnhancer.setCallbacksHelper(type, callbacks, SET_THREAD_CALLBACKS_NAME);
    }

    private static void setCallbacksHelper(Class type, Callback[] callbacks, String methodName) {
        try {
            Method setter = AdvancedEnhancer.getCallbacksSetter(type, methodName);
            setter.invoke(null, new Object[]{callbacks});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }

    private static Method getCallbacksSetter(Class type, String methodName) throws NoSuchMethodException {
        return type.getDeclaredMethod(methodName, Callback[].class);
    }

    private Object createUsingReflection(Class type) {
        AdvancedEnhancer.setThreadCallbacks(type, this.callbacks);
        try {
            if (this.argumentTypes != null) {
                Object object = ReflectUtils.newInstance((Class)type, (Class[])this.argumentTypes, (Object[])this.arguments);
                return object;
            }
            Object object = ReflectUtils.newInstance((Class)type);
            return object;
        }
        finally {
            AdvancedEnhancer.setThreadCallbacks(type, null);
        }
    }

    private void emitConstructors(ClassEmitter ce, List constructors) {
        boolean seenNull = false;
        for (Object constructor1 : constructors) {
            MethodInfo constructor = (MethodInfo)constructor1;
            CodeEmitter e = EmitUtils.begin_method((ClassEmitter)ce, (MethodInfo)constructor, (int)1);
            e.load_this();
            e.dup();
            e.load_args();
            Signature sig = constructor.getSignature();
            seenNull = seenNull || sig.getDescriptor().equals("()V");
            e.super_invoke_constructor(sig);
            e.invoke_static_this(BIND_CALLBACKS);
            if (!this.interceptDuringConstruction) {
                e.load_this();
                e.push(1);
                e.putfield(CONSTRUCTED_FIELD);
            }
            e.return_value();
            e.end_method();
        }
        if (!this.classOnly && !seenNull && this.arguments == null) {
            throw new IllegalArgumentException("Superclass has no null constructors but no arguments were given");
        }
    }

    private int[] getCallbackKeys() {
        int[] keys = new int[this.callbackTypes.length];
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            keys[i2] = i2;
        }
        return keys;
    }

    private static void emitGetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.begin_method(1, GET_CALLBACK, null);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key2, .Label end) {
                e.getfield(AdvancedEnhancer.getCallbackField(key2));
                e.goTo(end);
            }

            public void processDefault() {
                e.pop();
                e.aconst_null();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.begin_method(1, SET_CALLBACK, null);
        e.load_this();
        e.load_arg(1);
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key2, .Label end) {
                e.checkcast(AdvancedEnhancer.this.callbackTypes[key2]);
                e.putfield(AdvancedEnhancer.getCallbackField(key2));
                e.goTo(end);
            }

            public void processDefault() {
                .Type type = .Type.getType(AssertionError.class);
                e.new_instance(type);
                e.dup();
                e.invoke_constructor(type);
                e.athrow();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, SET_CALLBACKS, null);
        e.load_this();
        e.load_arg(0);
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            e.dup2();
            e.aaload(i2);
            e.checkcast(this.callbackTypes[i2]);
            e.putfield(AdvancedEnhancer.getCallbackField(i2));
        }
        e.return_value();
        e.end_method();
    }

    private void emitGetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, GET_CALLBACKS, null);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.push(this.callbackTypes.length);
        e.newarray(CALLBACK);
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            e.dup();
            e.push(i2);
            e.load_this();
            e.getfield(AdvancedEnhancer.getCallbackField(i2));
            e.aastore();
        }
        e.return_value();
        e.end_method();
    }

    private static void emitNewInstanceCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, NEW_INSTANCE, null);
        e.load_arg(0);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        AdvancedEnhancer.emitCommonNewInstance(e);
    }

    private static void emitCommonNewInstance(CodeEmitter e) {
        e.new_instance_this();
        e.dup();
        e.invoke_constructor_this();
        e.aconst_null();
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallback(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, SINGLE_NEW_INSTANCE, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                e.push(1);
                e.newarray(CALLBACK);
                e.dup();
                e.push(0);
                e.load_arg(0);
                e.aastore();
                e.invoke_static_this(SET_THREAD_CALLBACKS);
                break;
            }
            default: {
                e.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        AdvancedEnhancer.emitCommonNewInstance(e);
    }

    private static void emitNewInstanceMultiarg(ClassEmitter ce, List constructors) {
        final CodeEmitter e = ce.begin_method(1, MULTIARG_NEW_INSTANCE, null);
        e.load_arg(2);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        e.new_instance_this();
        e.dup();
        e.load_arg(0);
        EmitUtils.constructor_switch((CodeEmitter)e, (List)constructors, (ObjectSwitchCallback)new ObjectSwitchCallback(){

            public void processCase(Object key2, .Label end) {
                MethodInfo constructor = (MethodInfo)key2;
                .Type[] types = constructor.getSignature().getArgumentTypes();
                for (int i2 = 0; i2 < types.length; ++i2) {
                    e.load_arg(1);
                    e.push(i2);
                    e.aaload();
                    e.unbox(types[i2]);
                }
                e.invoke_constructor_this(constructor.getSignature());
                e.goTo(end);
            }

            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e.aconst_null();
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        e.return_value();
        e.end_method();
    }

    private void emitMethods(ClassEmitter ce, Map<Method, MethodInfo> methodMap, Map<Method, Method> covariantMethods) {
        CallbackGenerator[] generators = CallbackInfo.getGenerators((.Type[])this.callbackTypes);
        HashMap<MethodInfo, MethodInfo> covariantInfoMap = new HashMap<MethodInfo, MethodInfo>();
        for (Method method2 : methodMap.keySet()) {
            Method delegate = covariantMethods.get(method2);
            if (delegate == null) continue;
            covariantInfoMap.put(methodMap.get(method2), ReflectUtils.getMethodInfo((Member)delegate, (int)delegate.getModifiers()));
        }
        BridgeMethodGenerator bridgeMethodGenerator = new BridgeMethodGenerator(covariantInfoMap);
        HashMap<BridgeMethodGenerator, ArrayList<MethodInfo>> groups = new HashMap<BridgeMethodGenerator, ArrayList<MethodInfo>>();
        final HashMap<MethodInfo, Integer> indexes = new HashMap<MethodInfo, Integer>();
        final HashMap<MethodInfo, Integer> originalModifiers = new HashMap<MethodInfo, Integer>();
        final Map positions = CollectionUtils.getIndexMap(new ArrayList<MethodInfo>(methodMap.values()));
        for (Method actualMethod : methodMap.keySet()) {
            MethodInfo method3 = methodMap.get(actualMethod);
            int index = this.filter.accept(actualMethod);
            if (index >= this.callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            originalModifiers.put(method3, actualMethod != null ? actualMethod.getModifiers() : method3.getModifiers());
            indexes.put(method3, index);
            BridgeMethodGenerator generator = covariantMethods.containsKey(actualMethod) ? bridgeMethodGenerator : generators[index];
            ArrayList<MethodInfo> group = (ArrayList<MethodInfo>)groups.get(generator);
            if (group == null) {
                group = new ArrayList<MethodInfo>(methodMap.size());
                groups.put(generator, group);
            }
            group.add(method3);
        }
        CodeEmitter se = ce.getStaticHook();
        se.new_instance(THREAD_LOCAL);
        se.dup();
        se.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
        se.putfield(THREAD_CALLBACKS_FIELD);
        CallbackGenerator.Context context = new CallbackGenerator.Context(){

            public ClassLoader getClassLoader() {
                return AdvancedEnhancer.this.getClassLoader();
            }

            public int getOriginalModifiers(MethodInfo method2) {
                return (Integer)originalModifiers.get(method2);
            }

            public int getIndex(MethodInfo method2) {
                return (Integer)indexes.get(method2);
            }

            public void emitCallback(CodeEmitter e, int index) {
                AdvancedEnhancer.emitCurrentCallback(e, index);
            }

            public Signature getImplSignature(MethodInfo method2) {
                return AdvancedEnhancer.rename(method2.getSignature(), (Integer)positions.get(method2));
            }

            public void emitInvoke(CodeEmitter codeEmitter, MethodInfo methodInfo) {
                codeEmitter.super_invoke(methodInfo.getSignature());
            }

            public CodeEmitter beginMethod(ClassEmitter ce, MethodInfo method2) {
                CodeEmitter e = EmitUtils.begin_method((ClassEmitter)ce, (MethodInfo)method2);
                if (!AdvancedEnhancer.this.interceptDuringConstruction && !TypeUtils.isAbstract((int)method2.getModifiers())) {
                    .Label constructed = e.make_label();
                    e.load_this();
                    e.getfield(AdvancedEnhancer.CONSTRUCTED_FIELD);
                    e.if_jump(154, constructed);
                    e.load_this();
                    e.load_args();
                    e.super_invoke();
                    e.return_value();
                    e.mark(constructed);
                }
                return e;
            }
        };
        HashSet<BridgeMethodGenerator> seenGen = new HashSet<BridgeMethodGenerator>();
        for (int i2 = 0; i2 < this.callbackTypes.length + 1; ++i2) {
            BridgeMethodGenerator gen;
            BridgeMethodGenerator bridgeMethodGenerator2 = gen = i2 == this.callbackTypes.length ? bridgeMethodGenerator : generators[i2];
            if (seenGen.contains(gen)) continue;
            seenGen.add(gen);
            List fmethods = (List)groups.get(gen);
            if (fmethods == null) continue;
            try {
                gen.generate(ce, context, fmethods);
                gen.generateStatic(se, context, fmethods);
                continue;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new CodeGenerationException((Throwable)x);
            }
        }
        se.return_value();
        se.end_method();
    }

    private static void emitSetThreadCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, SET_THREAD_CALLBACKS, null);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.load_arg(0);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        e.return_value();
        e.end_method();
    }

    private static void emitSetStaticCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, SET_STATIC_CALLBACKS, null);
        e.load_arg(0);
        e.putfield(STATIC_CALLBACKS_FIELD);
        e.return_value();
        e.end_method();
    }

    private static void emitCurrentCallback(CodeEmitter e, int index) {
        e.load_this();
        e.getfield(AdvancedEnhancer.getCallbackField(index));
        e.dup();
        .Label end = e.make_label();
        e.ifnonnull(end);
        e.pop();
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.getfield(AdvancedEnhancer.getCallbackField(index));
        e.mark(end);
    }

    private void emitBindCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(26, BIND_CALLBACKS, null);
        Local me = e.make_local();
        e.load_arg(0);
        e.checkcast_this();
        e.store_local(me);
        .Label end = e.make_label();
        e.load_local(me);
        e.getfield(BOUND_FIELD);
        e.if_jump(154, end);
        e.load_local(me);
        e.push(1);
        e.putfield(BOUND_FIELD);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e.dup();
        .Label found_callback = e.make_label();
        e.ifnonnull(found_callback);
        e.pop();
        e.getfield(STATIC_CALLBACKS_FIELD);
        e.dup();
        e.ifnonnull(found_callback);
        e.pop();
        e.goTo(end);
        e.mark(found_callback);
        e.checkcast(CALLBACK_ARRAY);
        e.load_local(me);
        e.swap();
        for (int i2 = this.callbackTypes.length - 1; i2 >= 0; --i2) {
            if (i2 != 0) {
                e.dup2();
            }
            e.aaload(i2);
            e.checkcast(this.callbackTypes[i2]);
            e.putfield(AdvancedEnhancer.getCallbackField(i2));
        }
        e.mark(end);
        e.return_value();
        e.end_method();
    }

    private static String getCallbackField(int index) {
        return "CGLIB$CALLBACK_" + index;
    }

    public static interface EnhancerKey {
        public Object newInstance(String var1, String[] var2, CallbackFilter var3, .Type[] var4, boolean var5, boolean var6, Long var7);
    }
}

