/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.annotation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Collection;

class AnnotateOverriddenMethodsPredicate
implements PsiElementPredicate {
    AnnotateOverriddenMethodsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiMethod method2;
        int parameterIndex;
        if (!(element instanceof PsiAnnotation)) {
            return false;
        }
        PsiAnnotation annotation = (PsiAnnotation)element;
        String annotationName = annotation.getQualifiedName();
        if (annotationName == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiModifierList)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiMethod)) {
            if (!(grandParent instanceof PsiParameter)) {
                return false;
            }
            PsiParameter parameter = (PsiParameter)grandParent;
            PsiElement greatGrandParent = grandParent.getParent();
            if (!(greatGrandParent instanceof PsiParameterList)) {
                return false;
            }
            PsiParameterList parameterList = (PsiParameterList)greatGrandParent;
            parameterIndex = parameterList.getParameterIndex(parameter);
            PsiElement greatGreatGrandParent = greatGrandParent.getParent();
            if (!(greatGreatGrandParent instanceof PsiMethod)) {
                return false;
            }
            method2 = (PsiMethod)greatGreatGrandParent;
        } else {
            parameterIndex = -1;
            method2 = (PsiMethod)grandParent;
        }
        if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)method2, true)) {
            return false;
        }
        Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method2).findAll();
        if (overridingMethods.isEmpty()) {
            return false;
        }
        for (PsiMethod overridingMethod : overridingMethods) {
            if (parameterIndex == -1) {
                PsiAnnotation foundAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)overridingMethod, (String[])new String[]{annotationName});
                if (foundAnnotation != null) continue;
                return true;
            }
            PsiParameterList parameterList = overridingMethod.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[parameterIndex];
            PsiAnnotation foundAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])new String[]{annotationName});
            if (foundAnnotation != null) continue;
            return true;
        }
        return false;
    }
}

