/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ClassEscapesItsScopeInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ClassEscapesDefinedScope" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "getID"));
        }
        return "ClassEscapesDefinedScope";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.escapes.defined.scope.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.escapes.defined.scope.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassEscapesItsScopeVisitor();
    }

    private static class ClassEscapesItsScopeVisitor
    extends BaseInspectionVisitor {
        private ClassEscapesItsScopeVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor", "visitMethod"));
            }
            if (method2.isConstructor()) {
                return;
            }
            if (method2.hasModifierProperty("private")) {
                return;
            }
            this.checkForEscaping((PsiMember)method2, method2.getReturnType(), method2.getReturnTypeElement());
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor", "visitField"));
            }
            if (field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("private")) {
                return;
            }
            this.checkForEscaping((PsiMember)field, field.getType(), field.getTypeElement());
        }

        private void checkForEscaping(PsiMember member, PsiType type, PsiTypeElement typeElement) {
            if (type == null || typeElement == null) {
                return;
            }
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return;
            }
            PsiClass fieldClass = ((PsiClassType)componentType).resolve();
            if (fieldClass == null || fieldClass instanceof PsiTypeParameter) {
                return;
            }
            if (!ClassEscapesItsScopeVisitor.isLessRestrictiveScope(member, fieldClass)) {
                return;
            }
            PsiJavaCodeReferenceElement baseTypeElement = typeElement.getInnermostComponentReferenceElement();
            if (baseTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)baseTypeElement, new Object[0]);
        }

        private static boolean isLessRestrictiveScope(PsiMember method2, PsiClass aClass) {
            int methodScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)method2);
            int classScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)aClass);
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass != null && containingClass.getQualifiedName() == null) {
                return false;
            }
            int containingClassScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)containingClass);
            return methodScopeOrder > classScopeOrder && containingClassScopeOrder > classScopeOrder;
        }

        private static int getScopeOrder(PsiModifierListOwner element) {
            if (element.hasModifierProperty("public")) {
                return 4;
            }
            if (element.hasModifierProperty("private")) {
                return 1;
            }
            if (element.hasModifierProperty("protected")) {
                return 2;
            }
            return 3;
        }
    }
}

