/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadWithDefaultRunMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.with.default.run.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("InstantiatingAThreadWithDefaultRunMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection", "getID"));
        }
        return "InstantiatingAThreadWithDefaultRunMethod";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.with.default.run.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadWithDefaultRunMethodVisitor();
    }

    private static class ThreadWithDefaultRunMethodVisitor
    extends BaseInspectionVisitor {
        private ThreadWithDefaultRunMethodVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection$ThreadWithDefaultRunMethodVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
            if (anonymousClass != null) {
                if (ThreadWithDefaultRunMethodVisitor.definesRun(anonymousClass)) {
                    return;
                }
                this.processExpression(expression, anonymousClass.getBaseClassReference());
            } else {
                PsiJavaCodeReferenceElement classReference = expression.getClassReference();
                if (classReference == null) {
                    return;
                }
                this.processExpression(expression, classReference);
            }
        }

        private void processExpression(PsiNewExpression expression, PsiJavaCodeReferenceElement baseClassReference) {
            PsiExpression[] arguments;
            PsiElement referent = baseClassReference.resolve();
            if (referent == null) {
                return;
            }
            PsiClass referencedClass = (PsiClass)referent;
            String referencedClassName = referencedClass.getQualifiedName();
            if (!"java.lang.Thread".equals(referencedClassName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Runnable")) continue;
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private static boolean definesRun(PsiAnonymousClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method2 : methods = aClass.findMethodsByName("run", false)) {
                PsiParameterList parameterList = method2.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                return true;
            }
            return false;
        }
    }
}

