/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnGetClassInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronization.on.get.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnGetClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("synchronization.on.get.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnGetClassInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnGetClassVisitor();
    }

    private static class SynchronizationOnGetClassVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnGetClassVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
            super.visitSynchronizedStatement(statement2);
            PsiExpression lockExpression = ParenthesesUtils.stripParentheses(statement2.getLockExpression());
            if (!(lockExpression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)lockExpression;
            if (!MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Object", null, "getClass", new PsiType[0])) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, new Object[0]);
        }
    }
}

