/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListIndexOfReplaceableByContainsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("indexof.replaceable.by.contains.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String text;
        PsiBinaryExpression expression = (PsiBinaryExpression)infos[0];
        PsiExpression lhs = expression.getLOperand();
        if (lhs instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            text = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression.getOperationTokenType());
        } else {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression.getROperand();
            assert (callExpression != null);
            text = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression.getOperationTokenType());
        }
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IndexOfReplaceableByContainsFix();
    }

    static String createContainsExpressionText(@NotNull PsiMethodCallExpression call, boolean flipped, IElementType tokenType) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection", "createContainsExpressionText"));
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        String qualifierText = qualifierExpression == null ? "" : qualifierExpression.getText();
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression expression = argumentList.getExpressions()[0];
        String newExpressionText = qualifierText + ".contains(" + expression.getText() + ')';
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            return '!' + newExpressionText;
        }
        if (!flipped && (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE))) {
            return '!' + newExpressionText;
        }
        if (flipped && (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE))) {
            return '!' + newExpressionText;
        }
        return newExpressionText;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IndexOfReplaceableByContainsVisitor();
    }

    private static class IndexOfReplaceableByContainsVisitor
    extends BaseInspectionVisitor {
        private IndexOfReplaceableByContainsVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                if (IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(lhs, rhs, false, expression.getOperationTokenType())) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (rhs instanceof PsiMethodCallExpression && IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(rhs, lhs, true, expression.getOperationTokenType())) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean canBeReplacedByContains(PsiExpression lhs, PsiExpression rhs, boolean flipped, IElementType tokenType) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!IndexOfReplaceableByContainsVisitor.isIndexOfCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            if (flipped) {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.LT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.GE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.LE.equals(tokenType) || JavaTokenType.GT.equals(tokenType))) {
                    return true;
                }
            } else {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.GT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.LE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.GE.equals(tokenType) || JavaTokenType.LT.equals(tokenType))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIndexOfCall(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsVisitor", "isIndexOfCall"));
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"indexOf".equals(methodName)) {
                return false;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            Project project2 = expression.getProject();
            GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project2);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass javaUtilListClass = psiFacade.findClass("java.util.List", projectScope);
            if (javaUtilListClass == null) {
                return false;
            }
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiClassType javaUtilListType = factory.createType(javaUtilListClass);
            return javaUtilListType.isAssignableFrom(qualifierType);
        }
    }

    private static class IndexOfReplaceableByContainsFix
    extends InspectionGadgetsFix {
        private IndexOfReplaceableByContainsFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String newExpressionText;
            PsiBinaryExpression expression = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression.getOperationTokenType());
            } else {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)rhs;
                assert (callExpression != null);
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression.getOperationTokenType());
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpressionText);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.indexof.with.contains.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsFix", "getFamilyName"));
            }
            return string;
        }
    }
}

