/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestUtils {
    public static final String RUN_WITH = "org.junit.runner.RunWith";

    private TestUtils() {
    }

    public static boolean isInTestSourceContent(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile = file2 == null ? null : file2.getVirtualFile();
        return virtualFile != null && ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().isInTestSourceContent(virtualFile);
    }

    public static boolean isPartOfJUnitTestMethod(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/TestUtils", "isPartOfJUnitTestMethod"));
        }
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        return method2 != null && TestUtils.isJUnitTestMethod(method2);
    }

    public static boolean isJUnit4BeforeOrAfterMethod(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/TestUtils", "isJUnit4BeforeOrAfterMethod"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, (String)"org.junit.Before", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, (String)"org.junit.After", (boolean)true);
    }

    public static boolean isJUnit4BeforeClassOrAfterClassMethod(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/TestUtils", "isJUnit4BeforeClassOrAfterClassMethod"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, (String)"org.junit.BeforeClass", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, (String)"org.junit.AfterClass", (boolean)true);
    }

    public static boolean isJUnitTestMethod(@Nullable PsiMethod method2) {
        return TestUtils.isRunnable(method2) && (TestUtils.isJUnit3TestMethod(method2) || TestUtils.isJUnit4TestMethod(method2));
    }

    public static boolean isRunnable(PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        if (method2.hasModifierProperty("abstract") || method2.hasModifierProperty("static") || !method2.hasModifierProperty("public")) {
            return false;
        }
        PsiType returnType = method2.getReturnType();
        if (!PsiType.VOID.equals((Object)returnType)) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        return parameterList.getParametersCount() == 0;
    }

    public static boolean isJUnit3TestMethod(@Nullable PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        String methodName = method2.getName();
        String test = "test";
        if (!methodName.startsWith("test")) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        return TestUtils.isJUnitTestClass(containingClass);
    }

    public static boolean isJUnit4TestMethod(@Nullable PsiMethod method2) {
        return method2 != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, (String)"org.junit.Test", (boolean)true);
    }

    public static boolean isJUnitTestClass(@Nullable PsiClass targetClass) {
        return targetClass != null && InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"junit.framework.TestCase");
    }

    public static boolean isJUnit4TestClass(@Nullable PsiClass aClass, boolean runWithIsTestClass) {
        if (aClass == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)RUN_WITH, (boolean)true)) {
            return runWithIsTestClass;
        }
        for (PsiMethod method2 : aClass.getAllMethods()) {
            if (!TestUtils.isJUnit4TestMethod(method2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTestCode(PsiElement element) {
        if (TestUtils.isPartOfJUnitTestMethod(element)) {
            return true;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (containingClass != null && TestFrameworks.getInstance().isTestOrConfig(containingClass)) {
            return true;
        }
        return TestUtils.isInTestSourceContent(element);
    }
}

