/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DefiniteAssignment {
    @NotNull
    private final PsiVariable variable;
    private final Map<PsiElement, Boolean> definitelyAssignedBeforeBreak;
    private final Map<PsiElement, Boolean> definitelyUnassignedBeforeBreak;
    private final Map<PsiElement, Boolean> definitelyAssignedBeforeContinue;
    private final Map<PsiElement, Boolean> definitelyUnassignedBeforeContinue;
    private final Map<PsiElement, Boolean> definitelyAssignedBeforeReturn;
    private final Map<PsiElement, Boolean> definitelyUnassignedBeforeReturn;
    private boolean definitelyAssigned;
    private boolean definitelyUnassigned;

    public DefiniteAssignment(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/DefiniteAssignment", "<init>"));
        }
        this.definitelyAssignedBeforeBreak = new HashMap<PsiElement, Boolean>();
        this.definitelyUnassignedBeforeBreak = new HashMap<PsiElement, Boolean>();
        this.definitelyAssignedBeforeContinue = new HashMap<PsiElement, Boolean>();
        this.definitelyUnassignedBeforeContinue = new HashMap<PsiElement, Boolean>();
        this.definitelyAssignedBeforeReturn = new HashMap<PsiElement, Boolean>();
        this.definitelyUnassignedBeforeReturn = new HashMap<PsiElement, Boolean>();
        this.definitelyAssigned = false;
        this.definitelyUnassigned = true;
        this.variable = variable;
    }

    public void and(boolean definitelyAssigned, boolean definitelyUnassigned) {
        this.definitelyAssigned &= definitelyAssigned;
        this.definitelyUnassigned &= definitelyUnassigned;
    }

    public void assign(@NotNull PsiReferenceExpression expression, boolean definiteAssignment) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/DefiniteAssignment", "assign"));
        }
        if (definiteAssignment) {
            this.definitelyAssigned = true;
        } else {
            this.valueAccess(expression);
        }
        this.definitelyUnassigned = false;
    }

    public void andDefiniteAssignmentBeforeBreak(PsiStatement statement2) {
        this.definitelyAssigned &= DefiniteAssignment.removeValue((PsiElement)statement2, this.definitelyAssignedBeforeBreak);
        this.definitelyUnassigned &= DefiniteAssignment.removeValue((PsiElement)statement2, this.definitelyUnassignedBeforeBreak);
    }

    public void andDefiniteAssignmentBeforeContinue(PsiStatement statement2) {
        this.definitelyAssigned &= DefiniteAssignment.removeValue((PsiElement)statement2, this.definitelyAssignedBeforeContinue);
        this.definitelyUnassigned &= DefiniteAssignment.removeValue((PsiElement)statement2, this.definitelyUnassignedBeforeContinue);
    }

    public void andDefiniteAssignmentBeforeReturn(PsiMethod method2) {
        this.definitelyAssigned &= DefiniteAssignment.removeValue((PsiElement)method2, this.definitelyAssignedBeforeReturn);
        this.definitelyUnassigned &= DefiniteAssignment.removeValue((PsiElement)method2, this.definitelyUnassignedBeforeReturn);
    }

    private static boolean removeValue(PsiElement statement2, Map<PsiElement, Boolean> map) {
        Boolean aBoolean = map.remove(statement2);
        return aBoolean == null || aBoolean != false;
    }

    @NotNull
    public final PsiVariable getVariable() {
        PsiVariable psiVariable = this.variable;
        if (psiVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/DefiniteAssignment", "getVariable"));
        }
        return psiVariable;
    }

    public boolean isDefinitelyAssigned() {
        return this.definitelyAssigned;
    }

    public boolean isDefinitelyUnassigned() {
        return this.definitelyUnassigned;
    }

    public void set(boolean definitelyAssigned, boolean definitelyUnassigned) {
        this.definitelyAssigned = definitelyAssigned;
        this.definitelyUnassigned = definitelyUnassigned;
    }

    public boolean stop() {
        return false;
    }

    public void storeBeforeBreakStatement(PsiBreakStatement breakStatement) {
        PsiStatement statement2 = breakStatement.findExitedStatement();
        if (statement2 == null) {
            return;
        }
        this.storeFor((PsiElement)statement2, this.definitelyAssignedBeforeBreak, this.definitelyUnassignedBeforeBreak);
    }

    public void storeBeforeContinueStatement(PsiContinueStatement continueStatement) {
        PsiStatement statement2 = continueStatement.findContinuedStatement();
        if (statement2 == null) {
            return;
        }
        this.storeFor((PsiElement)statement2, this.definitelyAssignedBeforeContinue, this.definitelyUnassignedBeforeContinue);
    }

    public void storeBeforeReturn(PsiReturnStatement returnStatement) {
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (method2 == null || !method2.isConstructor()) {
            return;
        }
        this.storeFor((PsiElement)method2, this.definitelyAssignedBeforeReturn, this.definitelyUnassignedBeforeReturn);
    }

    private void storeFor(PsiElement element, Map<PsiElement, Boolean> definitelyAssignedMap, Map<PsiElement, Boolean> definitelyUnassignedMap) {
        Boolean existingDa = definitelyAssignedMap.get(element);
        Boolean existingDu = definitelyUnassignedMap.get(element);
        definitelyAssignedMap.put(element, this.definitelyAssigned && (existingDa == null || existingDa != false));
        definitelyUnassignedMap.put(element, this.definitelyUnassigned && (existingDu == null || existingDu != false));
    }

    @NonNls
    public String toString() {
        return "DefiniteAssignment{ variable=" + this.variable + ", definitelyAssigned=" + this.definitelyAssigned + ", definitelyUnassigned=" + this.definitelyUnassigned + '}';
    }

    public void valueAccess(PsiReferenceExpression expression) {
    }
}

