/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneUtils {
    private CloneUtils() {
    }

    public static boolean isCloneable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Cloneable");
    }

    public static boolean isDirectlyCloneable(@NotNull PsiClass aClass) {
        PsiClass[] interfaces;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/CloneUtils", "isDirectlyCloneable"));
        }
        for (PsiClass anInterface : interfaces = aClass.getInterfaces()) {
            String qualifiedName;
            if (anInterface == null || !"java.lang.Cloneable".equals(qualifiedName = anInterface.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClone(@Nullable PsiMethod method2) {
        PsiClassType javaLangObject;
        if (method2 == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)method2)) {
            javaLangObject = TypeUtils.getObjectType((PsiElement)method2);
        } else {
            if (method2.getReturnType() instanceof PsiPrimitiveType) {
                return false;
            }
            javaLangObject = null;
        }
        return MethodUtils.methodMatches(method2, null, (PsiType)javaLangObject, "clone", PsiType.EMPTY_ARRAY);
    }

    public static boolean onlyThrowsException(@NotNull PsiMethod method2) {
        PsiClass aClass;
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/CloneUtils", "onlyThrowsException"));
        }
        if (!(method2.hasModifierProperty("final") || (aClass = method2.getContainingClass()) != null && aClass.hasModifierProperty("final"))) {
            return false;
        }
        PsiStatement statement2 = ControlFlowUtils.getLastStatementInBlock(method2.getBody());
        return statement2 instanceof PsiThrowStatement;
    }
}

