/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class QuestionableNameInspectionBase
extends BaseInspection {
    @NonNls
    public String nameString = "aa,abc,bad,bar,bar2,baz,baz1,baz2,baz3,bb,blah,bogus,bool,cc,dd,defau1t,dummy,dummy2,ee,fa1se,ff,foo,foo1,foo2,foo3,foobar,four,fred,fred1,fred2,gg,hh,hello,hello1,hello2,hello3,ii,nu11,one,silly,silly2,string,two,that,then,three,whi1e,var";
    List<String> nameList = new ArrayList<String>(32);

    public QuestionableNameInspectionBase() {
        QuestionableNameInspectionBase.parseString(this.nameString, this.nameList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("questionable.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/QuestionableNameInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("questionable.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/QuestionableNameInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/naming/QuestionableNameInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        QuestionableNameInspectionBase.parseString(this.nameString, this.nameList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/naming/QuestionableNameInspectionBase", "writeSettings"));
        }
        this.nameString = QuestionableNameInspectionBase.formatString(this.nameList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new QuestionableNameVisitor();
    }

    private class QuestionableNameVisitor
    extends BaseInspectionVisitor {
        private final Set<String> nameSet;

        private QuestionableNameVisitor() {
            this.nameSet = new HashSet<String>(QuestionableNameInspectionBase.this.nameList);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/QuestionableNameInspectionBase$QuestionableNameVisitor", "visitVariable"));
            }
            String name = variable.getName();
            if (this.nameSet.contains(name)) {
                this.registerVariableError(variable, new Object[0]);
            }
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/QuestionableNameInspectionBase$QuestionableNameVisitor", "visitMethod"));
            }
            String name = method2.getName();
            if (this.nameSet.contains(name)) {
                this.registerMethodError(method2, new Object[0]);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/QuestionableNameInspectionBase$QuestionableNameVisitor", "visitClass"));
            }
            String name = aClass.getName();
            if (this.nameSet.contains(name)) {
                this.registerClassError(aClass, new Object[0]);
            }
        }
    }
}

