/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnboxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyUnboxed = false;
    @NonNls
    static final Map<String, String> s_unboxingMethods = new HashMap<String, String>(8);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.unboxing.superfluous.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportSuperfluouslyUnboxed");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnboxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnboxingVisitor();
    }

    static {
        s_unboxingMethods.put("java.lang.Integer", "intValue");
        s_unboxingMethods.put("java.lang.Short", "shortValue");
        s_unboxingMethods.put("java.lang.Boolean", "booleanValue");
        s_unboxingMethods.put("java.lang.Long", "longValue");
        s_unboxingMethods.put("java.lang.Byte", "byteValue");
        s_unboxingMethods.put("java.lang.Float", "floatValue");
        s_unboxingMethods.put("java.lang.Double", "doubleValue");
        s_unboxingMethods.put("java.lang.Character", "charValue");
    }

    private class UnnecessaryUnboxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnboxingVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!this.isUnboxingExpression((PsiExpression)expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || !this.canRemainBoxed((PsiExpression)expression, qualifier)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean canRemainBoxed(@NotNull PsiExpression expression, @NotNull PsiExpression unboxedExpression) {
            PsiType expectedType;
            PsiPolyadicExpression polyadicExpression;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "canRemainBoxed"));
            }
            if (unboxedExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboxedExpression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "canRemainBoxed"));
            }
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiPolyadicExpression && this.isPossibleObjectComparison(expression, polyadicExpression = (PsiPolyadicExpression)parent)) {
                return false;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                PsiTypeElement typeElement = typeCastExpression.getCastType();
                if (typeElement == null) {
                    return false;
                }
                PsiType castType = typeElement.getType();
                PsiType expressionType = expression.getType();
                if (expressionType == null || !castType.isAssignableFrom(expressionType)) {
                    return false;
                }
            } else if (parent instanceof PsiConditionalExpression) {
                PsiType type;
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                if (thenExpression == null) {
                    return false;
                }
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null) {
                    return false;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)thenExpression, (PsiElement)expression, (boolean)false) ? !((type = elseExpression.getType()) instanceof PsiPrimitiveType) : PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)expression, (boolean)false) && !((type = thenExpression.getType()) instanceof PsiPrimitiveType)) {
                    return false;
                }
            } else if (parent instanceof PsiExpressionList) {
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiCallExpression)) {
                    return true;
                }
                PsiCallExpression methodCallExpression = (PsiCallExpression)grandParent;
                if (!this.isSameMethodCalledWithoutUnboxing(methodCallExpression, expression, unboxedExpression)) {
                    return false;
                }
            }
            return !UnnecessaryUnboxingInspection.this.onlyReportSuperfluouslyUnboxed || (expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true)) instanceof PsiClassType;
        }

        private boolean isPossibleObjectComparison(PsiExpression expression, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (operand == expression || operand.getType() instanceof PsiPrimitiveType && !this.isUnboxingExpression(operand)) continue;
                return true;
            }
            return false;
        }

        private boolean isUnboxingExpression(PsiExpression expression) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            String qualifierTypeName = qualifierType.getCanonicalText();
            if (!s_unboxingMethods.containsKey(qualifierTypeName)) {
                return false;
            }
            String methodName = methodExpression.getReferenceName();
            String unboxingMethod = s_unboxingMethods.get(qualifierTypeName);
            return unboxingMethod.equals(methodName);
        }

        private boolean isSameMethodCalledWithoutUnboxing(@NotNull PsiCallExpression callExpression, @NotNull PsiExpression unboxingExpression, @NotNull PsiExpression unboxedExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "isSameMethodCalledWithoutUnboxing"));
            }
            if (unboxingExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboxingExpression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "isSameMethodCalledWithoutUnboxing"));
            }
            if (unboxedExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboxedExpression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "isSameMethodCalledWithoutUnboxing"));
            }
            PsiMethod originalMethod = callExpression.resolveMethod();
            if (originalMethod == null) {
                return false;
            }
            PsiMethod method2 = MethodCallUtils.findMethodWithReplacedArgument((PsiCall)callExpression, unboxingExpression, unboxedExpression);
            return originalMethod == method2;
        }
    }

    private static class UnnecessaryUnboxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryUnboxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unboxing.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiReferenceExpression referenceExpression;
            PsiElement element;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression strippedQualifier = ParenthesesUtils.stripParentheses(qualifier);
            if (strippedQualifier == null) {
                return;
            }
            if (strippedQualifier instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)strippedQualifier).resolve()) instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String classname = containingClass.getQualifiedName();
                if ("java.lang.Boolean".equals(classname)) {
                    String name = field.getName();
                    if ("TRUE".equals(name)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, "true");
                        return;
                    }
                    if ("FALSE".equals(name)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, "false");
                        return;
                    }
                }
            }
            String strippedQualifierText = strippedQualifier.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, strippedQualifierText);
        }
    }
}

