/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsReplaceableByObjectsCallInspection
extends BaseInspection {
    public boolean checkNotNull;

    @NotNull
    public JComponent createOptionsPanel() {
        SingleCheckboxOptionsPanel singleCheckboxOptionsPanel = new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.replaceable.by.objects.check.not.null.option", new Object[0]), (InspectionProfileEntry)this, "checkNotNull");
        if (singleCheckboxOptionsPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "createOptionsPanel"));
        }
        return singleCheckboxOptionsPanel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualsReplaceableByObjectsCallFix((String)infos[0], (String)infos[1], (Boolean)infos[2]);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsReplaceableByObjectsCallVisitor();
    }

    private static PsiExpression getArgumentExpression(PsiMethodCallExpression callExpression) {
        PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
        return expressions.length == 1 ? ParenthesesUtils.stripParentheses(expressions[0]) : null;
    }

    @Contract(value="null->null")
    @Nullable
    private static String getQualifiedVariableName(@Nullable PsiExpression expression) {
        if (expression instanceof PsiReferenceExpression) {
            PsiElement resolved;
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            String referenceName = referenceExpression.getReferenceName();
            if (referenceName != null && ((resolved = referenceExpression.resolve()) instanceof PsiVariable || resolved instanceof PsiClass)) {
                PsiExpression qualifierExpression = ParenthesesUtils.stripParentheses(referenceExpression.getQualifierExpression());
                if (qualifierExpression == null) {
                    return referenceName;
                }
                String qualifierName = EqualsReplaceableByObjectsCallInspection.getQualifiedVariableName(qualifierExpression);
                return qualifierName != null ? qualifierName + "." + referenceName : null;
            }
        } else if (expression instanceof PsiQualifiedExpression) {
            String name;
            PsiJavaCodeReferenceElement qualifier = ((PsiQualifiedExpression)expression).getQualifier();
            if (expression instanceof PsiThisExpression) {
                name = "this";
            } else if (expression instanceof PsiSuperExpression) {
                name = "super";
            } else {
                return null;
            }
            return qualifier != null ? qualifier.getQualifiedName() + "." + name : name;
        }
        return null;
    }

    private class EqualsReplaceableByObjectsCallVisitor
    extends BaseInspectionVisitor {
        private EqualsReplaceableByObjectsCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            String methodName = expression.getMethodExpression().getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression = this.getQualifierExpression(expression);
            if (qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression) {
                return;
            }
            PsiElement maybeBinary = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiPrefixExpression.class});
            if (maybeBinary instanceof PsiBinaryExpression && this.processNotNullCheck((PsiBinaryExpression)maybeBinary)) {
                return;
            }
            if (!EqualsReplaceableByObjectsCallInspection.this.checkNotNull) {
                if (qualifierExpression == null) {
                    return;
                }
                PsiExpression argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(expression);
                if (argumentExpression == null) {
                    return;
                }
                this.registerError((PsiElement)expression, qualifierExpression.getText(), argumentExpression.getText(), true);
            }
        }

        private PsiExpression getQualifierExpression(PsiMethodCallExpression expression) {
            return ParenthesesUtils.stripParentheses(expression.getMethodExpression().getQualifierExpression());
        }

        private boolean processNotNullCheck(PsiBinaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            PsiExpression rightOperand = ParenthesesUtils.stripParentheses(expression.getROperand());
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                return this.registerProblem(expression, rightOperand, true);
            }
            if (JavaTokenType.OROR.equals(tokenType) && rightOperand instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(((PsiPrefixExpression)rightOperand).getOperationTokenType())) {
                PsiExpression negatedRightOperand = ParenthesesUtils.stripParentheses(((PsiPrefixExpression)rightOperand).getOperand());
                return this.registerProblem(expression, negatedRightOperand, false);
            }
            return true;
        }

        private boolean registerProblem(@NotNull PsiBinaryExpression expression, PsiExpression rightOperand, boolean equal) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "registerProblem"));
            }
            if (rightOperand instanceof PsiMethodCallExpression) {
                PsiExpression argumentExpression;
                PsiExpression qualifierExpression;
                String qualifierName;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)rightOperand;
                PsiReferenceExpression nullCheckedExpression = ExpressionUtils.getReferenceExpressionFromNullComparison(expression.getLOperand(), !equal);
                String nullCheckedName = EqualsReplaceableByObjectsCallInspection.getQualifiedVariableName((PsiExpression)nullCheckedExpression);
                if (nullCheckedName != null && (qualifierName = EqualsReplaceableByObjectsCallInspection.getQualifiedVariableName(qualifierExpression = this.getQualifierExpression(methodCallExpression))) != null && qualifierName.equals(nullCheckedName) && (argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(methodCallExpression)) != null) {
                    String argumentName = EqualsReplaceableByObjectsCallInspection.getQualifiedVariableName(argumentExpression);
                    PsiBinaryExpression expressionToReplace = argumentName != null ? this.checkEqualityBefore((PsiExpression)expression, equal, qualifierName, argumentName) : expression;
                    this.registerError((PsiElement)expressionToReplace, nullCheckedExpression.getText(), argumentExpression.getText(), equal);
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private PsiExpression checkEqualityBefore(@NotNull PsiExpression expression, boolean equal, String qualifiedName1, String qualifiedName2) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "checkEqualityBefore"));
            }
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiBinaryExpression) {
                PsiExpression lhs;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if ((equal && JavaTokenType.OROR.equals(tokenType) || !equal && JavaTokenType.ANDAND.equals(tokenType)) && PsiTreeUtil.isAncestor((PsiElement)binaryExpression.getROperand(), (PsiElement)expression, (boolean)false) && this.isEquality(lhs = binaryExpression.getLOperand(), equal, qualifiedName1, qualifiedName2)) {
                    PsiBinaryExpression psiBinaryExpression = binaryExpression;
                    if (psiBinaryExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "checkEqualityBefore"));
                    }
                    return psiBinaryExpression;
                }
            }
            PsiExpression psiExpression = expression;
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "checkEqualityBefore"));
            }
            return psiExpression;
        }

        private boolean isEquality(PsiExpression expression, boolean equals, String qualifiedName1, String qualifiedName2) {
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            if (equals ? !JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) : !JavaTokenType.NE.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            PsiExpression leftOperand = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rightOperand = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            String leftName = EqualsReplaceableByObjectsCallInspection.getQualifiedVariableName(leftOperand);
            String rightName = EqualsReplaceableByObjectsCallInspection.getQualifiedVariableName(rightOperand);
            return leftName != null && rightName != null && (leftName.equals(qualifiedName1) && rightName.equals(qualifiedName2) || leftName.equals(qualifiedName2) && rightName.equals(qualifiedName1));
        }
    }

    private static class EqualsReplaceableByObjectsCallFix
    extends InspectionGadgetsFix {
        private final String myName1;
        private final String myName2;
        private final Boolean myEquals;

        public EqualsReplaceableByObjectsCallFix(String name1, String name2, Boolean equals) {
            this.myName1 = name1;
            this.myName2 = name2;
            this.myEquals = equals;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression) && !(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            String expressionText = "java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")";
            PsiReplacementUtil.replaceExpressionAndShorten(expression, this.myEquals != false ? expressionText : "!" + expressionText);
        }
    }
}

