/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import org.jetbrains.annotations.NotNull;

public class ParametersPerMethodInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        if ("MethodWithTooManyParameters" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection", "getID"));
        }
        return "MethodWithTooManyParameters";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameters.per.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer parameterCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("parameters.per.method.problem.descriptor", parameterCount);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("parameter.limit.option", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParametersPerMethodVisitor();
    }

    private class ParametersPerMethodVisitor
    extends BaseInspectionVisitor {
        private ParametersPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection$ParametersPerMethodVisitor", "visitMethod"));
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            if (method2.isConstructor()) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount <= ParametersPerMethodInspection.this.getLimit()) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method2)) {
                return;
            }
            this.registerMethodError(method2, parametersCount);
        }
    }
}

