/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NCSSVisitor;
import org.jetbrains.annotations.NotNull;

public class NonCommentSourceStatementsInspection
extends MethodMetricInspection {
    private static final int DEFAULT_LIMIT = 30;

    @NotNull
    public String getID() {
        if ("OverlyLongMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection", "getID"));
        }
        return "OverlyLongMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.comment.source.statements.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("non.comment.source.statements.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer statementCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("non.comment.source.statements.problem.descriptor", statementCount);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonCommentSourceStatementsMethodVisitor();
    }

    private class NonCommentSourceStatementsMethodVisitor
    extends BaseInspectionVisitor {
        private NonCommentSourceStatementsMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection$NonCommentSourceStatementsMethodVisitor", "visitMethod"));
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            NCSSVisitor visitor = new NCSSVisitor();
            method2.accept((PsiElementVisitor)visitor);
            int count = visitor.getStatementCount();
            if (count <= NonCommentSourceStatementsInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method2, count);
        }
    }
}

