/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UseOfObsoleteDateTimeApiInspection
extends BaseInspection {
    private static final Set<String> dateTimeNames = new HashSet<String>(Arrays.asList("java.util.Date", "java.util.Calendar", "java.util.GregorianCalendar", "java.util.TimeZone", "java.util.SimpleTimeZone"));

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.of.obsolete.date.time.api.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/UseOfObsoleteDateTimeApiInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.of.obsolete.date.time.api.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/UseOfObsoleteDateTimeApiInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObsoleteDateTimeApiVisitor();
    }

    private static class ObsoleteDateTimeApiVisitor
    extends BaseInspectionVisitor {
        private Boolean newDateTimeApiPresent = null;

        private ObsoleteDateTimeApiVisitor() {
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            PsiParameter parameter;
            PsiMethod method2;
            if (!this.isNewDateTimeApiPresent((PsiElement)typeElement)) {
                return;
            }
            super.visitTypeElement(typeElement);
            PsiType type = typeElement.getType();
            if (!ObsoleteDateTimeApiVisitor.isObsoleteDateTimeType(type)) {
                return;
            }
            PsiElement parent = typeElement.getParent();
            if (parent instanceof PsiMethod ? LibraryUtil.isOverrideOfLibraryMethod(method2 = (PsiMethod)parent) : parent instanceof PsiParameter && LibraryUtil.isOverrideOfLibraryMethodParameter((PsiVariable)(parameter = (PsiParameter)parent))) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitClass(PsiClass aClass) {
            if (!this.isNewDateTimeApiPresent((PsiElement)aClass)) {
                return;
            }
            super.visitClass(aClass);
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
                PsiElement target = referenceElement.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass extendsClass = (PsiClass)target;
                if (!ObsoleteDateTimeApiVisitor.isObsoleteDateTimeClass(extendsClass)) continue;
                this.registerError((PsiElement)referenceElement, new Object[0]);
            }
        }

        private boolean isNewDateTimeApiPresent(PsiElement context) {
            if (this.newDateTimeApiPresent == null) {
                this.newDateTimeApiPresent = ClassUtils.findClass("java.time.Instant", context) != null;
            }
            return this.newDateTimeApiPresent != Boolean.FALSE;
        }

        private static boolean isObsoleteDateTimeType(PsiType type) {
            if (type == null) {
                return false;
            }
            PsiType deepComponentType = type.getDeepComponentType();
            if (!(deepComponentType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)deepComponentType;
            PsiClass aClass = classType.resolve();
            return ObsoleteDateTimeApiVisitor.isObsoleteDateTimeClass(aClass);
        }

        private static boolean isObsoleteDateTimeClass(PsiClass aClass) {
            if (aClass == null) {
                return false;
            }
            return dateTimeNames.contains(aClass.getQualifiedName());
        }
    }
}

