/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryReturnInspection
extends BaseInspection {
    public boolean ignoreInThenBranch = false;

    @NotNull
    public String getID() {
        if ("UnnecessaryReturnStatement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection", "getID"));
        }
        return "UnnecessaryReturnStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.return.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("unnecessary.return.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.return.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.return.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInThenBranch");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("return");
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryReturnVisitor();
    }

    public static boolean isReturnRedundant(@NotNull PsiReturnStatement statement2, boolean ignoreInThenBranch, @Nullable Ref<Boolean> isInConstructorRef) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection", "isReturnRedundant"));
        }
        if (statement2.getReturnValue() != null) {
            return false;
        }
        PsiElement methodParent = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        PsiCodeBlock codeBlock = null;
        if (methodParent instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)methodParent;
            codeBlock = method2.getBody();
            if (isInConstructorRef != null) {
                isInConstructorRef.set((Object)method2.isConstructor());
            }
        } else if (methodParent instanceof PsiLambdaExpression) {
            isInConstructorRef.set((Object)false);
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)methodParent;
            PsiElement lambdaBody = lambdaExpression.getBody();
            if (lambdaBody instanceof PsiCodeBlock) {
                codeBlock = (PsiCodeBlock)lambdaBody;
            }
        } else {
            return false;
        }
        if (codeBlock == null) {
            return false;
        }
        if (!ControlFlowUtils.blockCompletesWithStatement(codeBlock, (PsiStatement)statement2)) {
            return false;
        }
        return !ignoreInThenBranch || !UnnecessaryReturnInspection.isInThenBranch((PsiStatement)statement2);
    }

    private static boolean isInThenBranch(PsiStatement statement2) {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (ifStatement == null) {
            return false;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch != null && !PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)statement2, (boolean)true);
    }

    private class UnnecessaryReturnVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryReturnVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection$UnnecessaryReturnVisitor", "visitReturnStatement"));
            }
            super.visitReturnStatement(statement2);
            Ref constructorRef = Ref.create();
            if (UnnecessaryReturnInspection.isReturnRedundant(statement2, UnnecessaryReturnInspection.this.ignoreInThenBranch, (Ref<Boolean>)constructorRef)) {
                this.registerStatementError((PsiStatement)statement2, constructorRef.get());
            }
        }
    }
}

