/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DuplicateBooleanBranchInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("duplicate.boolean.branch.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DuplicateBooleanBranchInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("duplicate.boolean.branch.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DuplicateBooleanBranchInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateBooleanBranchVisitor();
    }

    private static class DuplicateBooleanBranchVisitor
    extends BaseInspectionVisitor {
        private DuplicateBooleanBranchVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            PsiBinaryExpression parentExpression;
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR)) {
                return;
            }
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiBinaryExpression && tokenType.equals((parentExpression = (PsiBinaryExpression)parent).getOperationTokenType())) {
                return;
            }
            HashSet<PsiExpression> conditions = new HashSet<PsiExpression>();
            DuplicateBooleanBranchVisitor.collectConditions((PsiExpression)expression, conditions, tokenType);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            PsiExpression[] conditionArray = conditions.toArray(new PsiExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            for (int i2 = 0; i2 < conditionArray.length; ++i2) {
                if (matched[i2]) continue;
                PsiExpression condition = conditionArray[i2];
                for (int j = i2 + 1; j < conditionArray.length; ++j) {
                    if (matched[j]) continue;
                    PsiExpression testCondition = conditionArray[j];
                    boolean areEquivalent = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(condition, testCondition);
                    if (!areEquivalent) continue;
                    this.registerError((PsiElement)testCondition, new Object[0]);
                    if (!matched[i2]) {
                        this.registerError((PsiElement)condition, new Object[0]);
                    }
                    matched[i2] = true;
                    matched[j] = true;
                }
            }
        }

        private static void collectConditions(PsiExpression condition, Set<PsiExpression> conditions, IElementType tokenType) {
            PsiPolyadicExpression polyadicExpression;
            IElementType testTokeType;
            if (condition == null) {
                return;
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                PsiExpression contents = parenthesizedExpression.getExpression();
                DuplicateBooleanBranchVisitor.collectConditions(contents, conditions, tokenType);
                return;
            }
            if (condition instanceof PsiPolyadicExpression && (testTokeType = (polyadicExpression = (PsiPolyadicExpression)condition).getOperationTokenType()).equals(tokenType)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    DuplicateBooleanBranchVisitor.collectConditions(operand, conditions, tokenType);
                }
                return;
            }
            conditions.add(condition);
        }
    }
}

