/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.ig.psiutils.ParenthesesUtils;

class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static boolean isReturn(PsiStatement statement2, String value) {
        if (statement2 == null) {
            return false;
        }
        if (!(statement2 instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
        PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
        if (returnValue == null) {
            return false;
        }
        String returnValueText = returnValue.getText();
        return value.equals(returnValueText);
    }

    public static boolean isAssignment(PsiStatement statement2, String value) {
        if (statement2 == null) {
            return false;
        }
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
        PsiExpression rhs = ParenthesesUtils.stripParentheses(assignment.getRExpression());
        if (rhs == null) {
            return false;
        }
        String rhsText = rhs.getText();
        return value.equals(rhsText);
    }
}

