/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.bugs.NonFinalFieldsVisitor;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsUsesNonFinalVariableInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("NonFinalFieldReferenceInEquals" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsUsesNonFinalVariableInspection", "getID"));
        }
        return "NonFinalFieldReferenceInEquals";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.final.field.in.equals.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsUsesNonFinalVariableInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.final.field.in.equals.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsUsesNonFinalVariableInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsUsesNonFinalVariableVisitor();
    }

    private static class EqualsUsesNonFinalVariableVisitor
    extends NonFinalFieldsVisitor {
        private EqualsUsesNonFinalVariableVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/EqualsUsesNonFinalVariableInspection$EqualsUsesNonFinalVariableVisitor", "visitMethod"));
            }
            if (MethodUtils.isEquals(method2)) {
                this.checkUsedNonFinalFields(method2);
            }
        }
    }
}

