/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurable;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaConflictNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"json.schema.conflict.notification.panel");
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaService myJsonSchemaService;

    public JsonSchemaConflictNotificationProvider(@NotNull Project project2, @NotNull JsonSchemaService jsonSchemaService) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "<init>"));
        }
        if (jsonSchemaService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonSchemaService", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "<init>"));
        }
        this.myProject = project2;
        this.myJsonSchemaService = jsonSchemaService;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key2 = KEY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "getKey"));
        }
        return key2;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "createNotificationPanel"));
        }
        List<Pair<Boolean, String>> descriptors = this.myJsonSchemaService.getMatchingSchemaDescriptors(file2);
        if (descriptors == null || descriptors.size() <= 1) {
            return null;
        }
        Worker worker = new Worker();
        String message = worker.createMessage(descriptors);
        if (message == null) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(){

            public Color getBackground() {
                return LightColors.RED;
            }
        };
        panel2.setText(message);
        panel2.createActionLabel("Edit JSON Schema Mappings", () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "lambda$createNotificationPanel$0"));
            }
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new JsonSchemaMappingsConfigurable(this.myProject));
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
        });
        return panel2;
    }

    private static class Worker {
        private Worker() {
        }

        public String createMessage(@NotNull List<Pair<Boolean, String>> descriptors) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider$Worker", "createMessage"));
            }
            int numOfSystemSchemas = 0;
            for (Pair<Boolean, String> pair : descriptors) {
                if (Boolean.TRUE.equals(pair.getFirst())) continue;
                ++numOfSystemSchemas;
            }
            if (numOfSystemSchemas == 1) {
                return null;
            }
            boolean withTypes = numOfSystemSchemas > 0;
            ArrayList<Object> names = new ArrayList<Object>();
            for (Pair<Boolean, String> pair : descriptors) {
                if (withTypes) {
                    names.add((Boolean.TRUE.equals(pair.getFirst()) ? "user" : "system") + " schema '" + (String)pair.getSecond() + "'");
                    continue;
                }
                names.add(pair.getSecond());
            }
            return "<html>There are several JSON Schemas mapped to this file: " + StringUtil.join(names, (String)"; ") + "</html>";
        }
    }
}

