/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public JsonSchemaVfsListener(final Project project2, final @NotNull JsonSchemaServiceImpl service) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/jetbrains/jsonSchema/JsonSchemaVfsListener", "<init>"));
        }
        super((VirtualFileListener)new VirtualFileAdapter(){
            @NotNull
            private final JsonSchemaServiceImpl myService;
            private JsonSchemaMappingsProjectConfiguration myMappingsProjectConfiguration;
            private final ZipperUpdater myUpdater;
            private final Set<VirtualFile> myDirtySchemas;
            private final Runnable myRunnable;
            {
                this.myService = service;
                this.myMappingsProjectConfiguration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
                this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
                this.myDirtySchemas = ContainerUtil.newConcurrentSet();
                this.myRunnable = () -> {
                    Editor[] editors;
                    HashSet<VirtualFile> scope = new HashSet<VirtualFile>(this.myDirtySchemas);
                    this.myDirtySchemas.removeAll(scope);
                    if (scope.isEmpty()) {
                        return;
                    }
                    DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
                    PsiManager psiManager = PsiManager.getInstance((Project)project2);
                    block0: for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
                        Collection<Pair<VirtualFile, String>> collection;
                        VirtualFile file2;
                        if (!(editor instanceof EditorEx) || (file2 = ((EditorEx)editor).getVirtualFile()) == null || !file2.isValid() || !((Object)((Object)JsonFileType.INSTANCE)).equals(file2.getFileType()) || (collection = this.myService.getSchemaFilesByFile(file2)) == null || collection.isEmpty()) continue;
                        for (Pair<VirtualFile, String> pair : collection) {
                            if (!scope.contains(pair.getFirst())) continue;
                            ApplicationManager.getApplication().runReadAction(() -> {
                                PsiFile psiFile = psiManager.findFile(file2);
                                if (psiFile != null) {
                                    analyzer.restart(psiFile);
                                }
                            });
                            continue block0;
                        }
                    }
                };
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$1", "contentsChanged"));
                }
                this.onFileChange(event.getFile());
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$1", "fileCreated"));
                }
                this.onFileChange(event.getFile());
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$1", "beforeFileDeletion"));
                }
                this.onFileChange(event.getFile());
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$1", "beforeFileMovement"));
                }
                this.onFileChange(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$1", "fileMoved"));
                }
                this.onFileChange(event.getFile());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$1", "fileCopied"));
                }
                this.onFileChange(event.getFile());
            }

            private void onFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$1", "onFileChange"));
                }
                if (this.myMappingsProjectConfiguration.isRegisteredSchemaFile(schemaFile)) {
                    this.myService.dropProviderFromCache(schemaFile);
                    this.myDirtySchemas.add(schemaFile);
                    this.myUpdater.queue(this.myRunnable);
                }
            }
        });
    }
}

