/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ReferencePainter {
    public void customizePainter(@NotNull JComponent var1, @NotNull Collection<VcsRef> var2, @NotNull Color var3, @NotNull Color var4, boolean var5, int var6);

    public void paint(@NotNull Graphics2D var1, int var2, int var3, int var4);

    public Dimension getSize();

    public boolean isLeftAligned();

    default public Font getReferenceFont() {
        return RectanglePainter.getFont();
    }

    @Nullable
    public static VcsLogRefManager getRefManager(@NotNull VcsLogData logData, @NotNull Collection<VcsRef> references) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/render/ReferencePainter", "getRefManager"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/vcs/log/ui/render/ReferencePainter", "getRefManager"));
        }
        if (!references.isEmpty()) {
            VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references))).getRoot();
            return logData.getLogProvider(root).getReferenceManager();
        }
        return null;
    }
}

