/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;

public class ShowGraphHistoryAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        assert (project2 != null);
        VirtualFile file2 = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        VcsLogManager logManager = VcsProjectLog.getInstance(project2).getLogManager();
        assert (logManager != null);
        VcsLogStructureFilterImpl fileFilter = new VcsLogStructureFilterImpl((Collection<FilePath>)Collections.singleton(VcsUtil.getFilePath((VirtualFile)file2)));
        VcsLogContentProvider.openLogTab(logManager, project2, file2.getName(), (VcsLogFilter)fileFilter);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (!Registry.is((String)"vcs.log.graph.history")) {
            presentation.setEnabledAndVisible(false);
        } else {
            VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            Project project2 = e.getProject();
            if (file2 == null || project2 == null) {
                presentation.setEnabledAndVisible(false);
            } else {
                VirtualFile root = ProjectLevelVcsManager.getInstance((Project)project2).getVcsRootFor(file2);
                VcsLogData dataManager = VcsProjectLog.getInstance(project2).getDataManager();
                if (root == null || dataManager == null) {
                    presentation.setEnabledAndVisible(false);
                } else {
                    presentation.setEnabledAndVisible(dataManager.getIndex().isIndexed(root));
                }
            }
        }
    }
}

