/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.filter.VcsLogUserFilterImpl;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myLogUi;
    private boolean myShouldHighlightUser;

    public MyCommitsHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        if (logUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        this.myShouldHighlightUser = false;
        this.myLogData = logData;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(@NotNull VcsShortCommitDetails details, boolean isSelected) {
        VcsUser currentUser;
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
        }
        if (!this.myLogUi.isHighlighterEnabled("MY_COMMITS")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        if (this.myShouldHighlightUser && (currentUser = this.myLogData.getCurrentUser().get(details.getRoot())) != null && VcsUserUtil.isSamePerson(currentUser, details.getAuthor())) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.bold();
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "update"));
        }
        this.myShouldHighlightUser = !this.isSingleUser() && !MyCommitsHighlighter.isFilteredByCurrentUser(dataPack.getFilters());
    }

    private boolean isSingleUser() {
        NotNullFunction nameToString = user -> VcsUserUtil.getNameInStandardForm(VcsUserUtil.getShortPresentation(user));
        HashSet allUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myLogData.getAllUsers(), (Function)nameToString));
        HashSet currentUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myLogData.getCurrentUser().values(), (Function)nameToString));
        return allUserNames.size() == currentUserNames.size() && currentUserNames.containsAll(allUserNames);
    }

    private static boolean isFilteredByCurrentUser(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "isFilteredByCurrentUser"));
        }
        VcsLogUserFilter userFilter = filters.getUserFilter();
        if (userFilter == null) {
            return false;
        }
        Collection<String> filterByName = ((VcsLogUserFilterImpl)userFilter).getUserNamesForPresentation();
        return Collections.singleton("me").containsAll(filterByName);
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "MY_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            if (logData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            if (logUi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            MyCommitsHighlighter myCommitsHighlighter = new MyCommitsHighlighter(logData, logUi);
            if (myCommitsHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            return myCommitsHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("My Commits" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getTitle"));
            }
            return "My Commits";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

