/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog {
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final LazyVcsLogManager myLogManager;
    private volatile VcsLogUiImpl myUi;

    public VcsProjectLog(@NotNull Project project2, @NotNull VcsLogTabsProperties uiProperties) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/impl/VcsProjectLog", "<init>"));
        }
        this.myLogManager = new LazyVcsLogManager();
        this.myProject = project2;
        this.myMessageBus = project2.getMessageBus();
        this.myUiProperties = uiProperties;
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @NotNull
    private Collection<VcsRoot> getVcsRoots() {
        List<VcsRoot> list = Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcsRoots());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsProjectLog", "getVcsRoots"));
        }
        return list;
    }

    @NotNull
    public JComponent initMainLog(@NotNull String contentTabName) {
        if (contentTabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTabName", "com/intellij/vcs/log/impl/VcsProjectLog", "initMainLog"));
        }
        this.myUi = this.myLogManager.getValue().createLogUi("MAIN", contentTabName, null);
        VcsLogPanel vcsLogPanel = new VcsLogPanel(this.myLogManager.getValue(), this.myUi);
        if (vcsLogPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsProjectLog", "initMainLog"));
        }
        return vcsLogPanel;
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        return this.myUi;
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    private void recreateLog() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.disposeLog();
            if (this.hasDvcsRoots()) {
                this.createLog();
            }
        });
    }

    private void disposeLog() {
        this.myUi = null;
        this.myLogManager.drop();
    }

    public void createLog() {
        VcsLogCachesInvalidator invalidator;
        VcsLogManager logManager = this.myLogManager.getValue();
        if (logManager.isLogVisible()) {
            logManager.scheduleInitialization();
        } else if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class))).isValid()) {
            HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
        }
    }

    private boolean hasDvcsRoots() {
        return !VcsLogManager.findLogProviders(this.getVcsRoots(), this.myProject).isEmpty();
    }

    public static VcsProjectLog getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog", "getInstance"));
        }
        return (VcsProjectLog)ServiceManager.getService((Project)project2, VcsProjectLog.class);
    }

    public static interface ProjectLogListener {
        public void logCreated();

        public void logDisposed();
    }

    public static class InitLogStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$InitLogStartupActivity", "runActivity"));
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
            MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
            connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> projectLog.recreateLog());
            if (projectLog.hasDvcsRoots()) {
                ApplicationManager.getApplication().invokeLater(projectLog::createLog);
            }
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        public synchronized VcsLogManager getValue() {
            if (this.myValue == null) {
                this.myValue = this.compute();
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated();
            }
            VcsLogManager vcsLogManager = this.myValue;
            if (vcsLogManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager", "getValue"));
            }
            return vcsLogManager;
        }

        @NotNull
        protected synchronized VcsLogManager compute() {
            VcsLogManager vcsLogManager = new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, VcsProjectLog.this.getVcsRoots(), false, () -> VcsProjectLog.this.recreateLog());
            if (vcsLogManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager", "compute"));
            }
            return vcsLogManager;
        }

        public synchronized void drop() {
            if (this.myValue != null) {
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed();
                Disposer.dispose((Disposable)this.myValue);
            }
            this.myValue = null;
        }

        @Nullable
        public synchronized VcsLogManager getCached() {
            return this.myValue;
        }
    }
}

