/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogFilterer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PostponableLogRefresher
implements VcsLogRefresher {
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    private final Set<VirtualFile> myRootsToRefresh;
    @NotNull
    private final Set<VcsLogWindow> myLogWindows;

    public PostponableLogRefresher(@NotNull VcsLogData logData) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/impl/PostponableLogRefresher", "<init>"));
        }
        this.myRootsToRefresh = ContainerUtil.newHashSet();
        this.myLogWindows = ContainerUtil.newHashSet();
        this.myLogData = logData;
        this.myLogData.addDataPackChangeListener(dataPack -> {
            for (VcsLogWindow window : this.myLogWindows) {
                PostponableLogRefresher.dataPackArrived(window.getFilterer(), window.isVisible());
            }
        });
    }

    @NotNull
    public Disposable addLogWindow(@NotNull VcsLogWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/vcs/log/impl/PostponableLogRefresher", "addLogWindow"));
        }
        this.myLogWindows.add(window);
        this.filtererActivated(window.getFilterer(), true);
        Disposable disposable = () -> {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/vcs/log/impl/PostponableLogRefresher", "lambda$addLogWindow$1"));
            }
            this.myLogWindows.remove(window);
        };
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/PostponableLogRefresher", "addLogWindow"));
        }
        return disposable;
    }

    @NotNull
    public Disposable addLogWindow(@NotNull VcsLogFilterer filterer) {
        if (filterer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterer", "com/intellij/vcs/log/impl/PostponableLogRefresher", "addLogWindow"));
        }
        Disposable disposable = this.addLogWindow(new VcsLogWindow(filterer));
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/PostponableLogRefresher", "addLogWindow"));
        }
        return disposable;
    }

    public static boolean keepUpToDate() {
        return Registry.is((String)"vcs.log.keep.up.to.date") && !PowerSaveMode.isEnabled();
    }

    protected boolean canRefreshNow() {
        if (PostponableLogRefresher.keepUpToDate()) {
            return true;
        }
        return this.isLogVisible();
    }

    public boolean isLogVisible() {
        for (VcsLogWindow window : this.myLogWindows) {
            if (!window.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void filtererActivated(@NotNull VcsLogFilterer filterer, boolean firstTime) {
        if (filterer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterer", "com/intellij/vcs/log/impl/PostponableLogRefresher", "filtererActivated"));
        }
        if (!this.myRootsToRefresh.isEmpty()) {
            this.refreshPostponedRoots();
        } else {
            if (firstTime) {
                filterer.onRefresh();
            }
            filterer.setValid(true);
        }
    }

    private static void dataPackArrived(@NotNull VcsLogFilterer filterer, boolean visible) {
        if (filterer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterer", "com/intellij/vcs/log/impl/PostponableLogRefresher", "dataPackArrived"));
        }
        if (!visible) {
            filterer.setValid(false);
        }
        filterer.onRefresh();
    }

    public void refresh(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/PostponableLogRefresher", "refresh"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/PostponableLogRefresher", "lambda$refresh$2"));
            }
            if (this.canRefreshNow()) {
                this.myLogData.refresh(Collections.singleton(root));
            } else {
                this.myRootsToRefresh.add(root);
            }
        }, ModalityState.any());
    }

    protected void refreshPostponedRoots() {
        HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>(this.myRootsToRefresh);
        this.myRootsToRefresh.removeAll(toRefresh);
        this.myLogData.refresh(toRefresh);
    }

    @NotNull
    public Set<VcsLogWindow> getLogWindows() {
        Set<VcsLogWindow> set2 = this.myLogWindows;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/PostponableLogRefresher", "getLogWindows"));
        }
        return set2;
    }

    public static class VcsLogWindow {
        @NotNull
        private final VcsLogFilterer myFilterer;

        public VcsLogWindow(@NotNull VcsLogFilterer filterer) {
            if (filterer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterer", "com/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow", "<init>"));
            }
            this.myFilterer = filterer;
        }

        @NotNull
        public VcsLogFilterer getFilterer() {
            VcsLogFilterer vcsLogFilterer = this.myFilterer;
            if (vcsLogFilterer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow", "getFilterer"));
            }
            return vcsLogFilterer;
        }

        public boolean isVisible() {
            return true;
        }
    }
}

