/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class HeavyAwareExecutor {
    HeavyAwareExecutor() {
    }

    static void executeOutOfHeavyProcessLater(@NotNull Runnable command, int delayMs) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/vcs/log/impl/HeavyAwareExecutor", "executeOutOfHeavyProcessLater"));
        }
        HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/vcs/log/impl/HeavyAwareExecutor", "lambda$executeOutOfHeavyProcessLater$1"));
            }
            JobScheduler.getScheduler().schedule(() -> {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/vcs/log/impl/HeavyAwareExecutor", "lambda$null$0"));
                }
                if (HeavyProcessLatch.INSTANCE.isRunning()) {
                    HeavyAwareExecutor.executeOutOfHeavyProcessLater(command, delayMs);
                } else {
                    command.run();
                }
            }, (long)delayMs, TimeUnit.MILLISECONDS);
        });
    }
}

