/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import org.jetbrains.annotations.NotNull;

class ByteArrayUtils {
    private static final int BYTE_OFFSET = 8;
    private static final int BYTE_MASK = 255;

    ByteArrayUtils() {
    }

    public static int countBytesAfterCompression(@NotNull IntList deltaList) {
        if (deltaList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deltaList", "com/intellij/vcs/log/graph/utils/impl/ByteArrayUtils", "countBytesAfterCompression"));
        }
        int count = 0;
        for (int i2 = 0; i2 < deltaList.size(); ++i2) {
            count += ByteArrayUtils.sizeOf(deltaList.get(i2));
        }
        return count;
    }

    public static int sizeOf(int value) {
        if (value < 0) {
            value ^= 0xFFFFFFFF;
        }
        value >>= 7;
        for (int i2 = 1; i2 < 4; ++i2) {
            if (value == 0) {
                return i2;
            }
            value >>= 8;
        }
        return 4;
    }

    public static void writeDelta(int startIndex, int value, int sizeOf, byte[] bytes) {
        for (int i2 = sizeOf - 1; i2 >= 0; --i2) {
            bytes[startIndex + i2] = (byte)value;
            value >>= 8;
        }
    }

    public static int readDelta(int startIndex, int sizeOf, byte[] bytes) {
        int i2;
        boolean isNegative;
        int result2 = 0;
        boolean bl = isNegative = bytes[startIndex] < 0;
        if (isNegative) {
            for (i2 = 0; i2 < 4 - sizeOf; ++i2) {
                result2 <<= 8;
                result2 |= 0xFF;
            }
        }
        for (i2 = startIndex; i2 < startIndex + sizeOf; ++i2) {
            result2 <<= 8;
            result2 |= bytes[i2] & 0xFF;
        }
        return result2;
    }

    public static int groundPointCount(int arraySize, int blockSize) {
        if (arraySize == 0) {
            return 1;
        }
        return (arraySize - 1) / blockSize + 1;
    }
}

