/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphLayoutBuilder {
    private static final Logger LOG = Logger.getInstance(GraphLayoutBuilder.class);
    @NotNull
    private final LinearGraph myGraph;
    @NotNull
    private final int[] myLayoutIndex;
    @NotNull
    private final List<Integer> myHeadNodeIndex;
    @NotNull
    private final int[] myStartLayoutIndexForHead;
    @NotNull
    private final DfsUtil myDfsUtil;
    private int currentLayoutIndex;

    @NotNull
    public static GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull Comparator<Integer> headNodeIndexComparator) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        if (headNodeIndexComparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headNodeIndexComparator", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        List<Integer> heads = new ArrayList();
        for (int i2 = 0; i2 < graph.nodesCount(); ++i2) {
            if (LinearGraphUtils.getUpNodes(graph, i2).size() != 0) continue;
            heads.add(i2);
        }
        try {
            heads = ContainerUtil.sorted(heads, headNodeIndexComparator);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        GraphLayoutBuilder builder = new GraphLayoutBuilder(graph, heads);
        GraphLayoutImpl graphLayoutImpl = builder.build();
        if (graphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        return graphLayoutImpl;
    }

    private GraphLayoutBuilder(@NotNull LinearGraph graph, @NotNull List<Integer> headNodeIndex) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "<init>"));
        }
        if (headNodeIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headNodeIndex", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "<init>"));
        }
        this.myDfsUtil = new DfsUtil();
        this.currentLayoutIndex = 1;
        this.myGraph = graph;
        this.myLayoutIndex = new int[graph.nodesCount()];
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = new int[headNodeIndex.size()];
    }

    private void dfs(int nodeIndex) {
        this.myDfsUtil.nodeDfsIterator(nodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                boolean firstVisit;
                boolean bl = firstVisit = GraphLayoutBuilder.this.myLayoutIndex[currentNode] == 0;
                if (firstVisit) {
                    ((GraphLayoutBuilder)GraphLayoutBuilder.this).myLayoutIndex[currentNode] = GraphLayoutBuilder.this.currentLayoutIndex;
                }
                int childWithoutLayoutIndex = -1;
                for (int childNodeIndex : LinearGraphUtils.getDownNodes(GraphLayoutBuilder.this.myGraph, currentNode)) {
                    if (GraphLayoutBuilder.this.myLayoutIndex[childNodeIndex] != 0) continue;
                    childWithoutLayoutIndex = childNodeIndex;
                    break;
                }
                if (childWithoutLayoutIndex == -1) {
                    if (firstVisit) {
                        GraphLayoutBuilder.this.currentLayoutIndex++;
                    }
                    return -1;
                }
                return childWithoutLayoutIndex;
            }
        });
    }

    @NotNull
    private GraphLayoutImpl build() {
        for (int i2 = 0; i2 < this.myHeadNodeIndex.size(); ++i2) {
            int headNodeIndex = this.myHeadNodeIndex.get(i2);
            this.myStartLayoutIndexForHead[i2] = this.currentLayoutIndex;
            this.dfs(headNodeIndex);
        }
        GraphLayoutImpl graphLayoutImpl = new GraphLayoutImpl(this.myLayoutIndex, this.myHeadNodeIndex, this.myStartLayoutIndexForHead);
        if (graphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        return graphLayoutImpl;
    }
}

