/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStorage;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.InMemoryMap;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TroveUtil;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.filter.VcsLogUserFilterImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import gnu.trove.THash;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPersistentIndex
implements VcsLogIndex,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    private static final int VERSION = 0;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsLogStorage myHashMap;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final PersistentMap<Integer, String> myMessagesIndex;
    @Nullable
    private final VcsLogMessagesTrigramIndex myTrigramIndex;
    @Nullable
    private final VcsLogUserIndex myUserIndex;
    @Nullable
    private final VcsLogPathsIndex myPathsIndex;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks;
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToIndex;

    public VcsLogPersistentIndex(@NotNull Project project2, @NotNull VcsLogStorage hashMap, @NotNull VcsLogProgress progress, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable disposableParent) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (fatalErrorsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorsConsumer", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        this.mySingleTaskController = new MySingleTaskController();
        this.myNumberOfTasks = ContainerUtil.newHashMap();
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        this.myHashMap = hashMap;
        this.myProject = project2;
        this.myProgress = progress;
        this.myProviders = providers;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myRoots = ContainerUtil.newLinkedHashSet();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            if (!((Boolean)VcsLogProperties.get((VcsLogProvider)entry.getValue(), (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING)).booleanValue()) continue;
            this.myRoots.add(entry.getKey());
        }
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        String logId = PersistentUtil.calcLogId(this.myProject, providers);
        this.myMessagesIndex = this.createMap((KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, "messages", logId, 0);
        this.myTrigramIndex = (VcsLogMessagesTrigramIndex)this.createIndex(() -> {
            if (fatalErrorsConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorsConsumer", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$new$0"));
            }
            return new VcsLogMessagesTrigramIndex(logId, fatalErrorsConsumer, this);
        });
        this.myUserIndex = (VcsLogUserIndex)this.createIndex(() -> {
            if (fatalErrorsConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorsConsumer", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$new$1"));
            }
            return new VcsLogUserIndex(logId, this.myUserRegistry, fatalErrorsConsumer, this);
        });
        this.myPathsIndex = (VcsLogPathsIndex)this.createIndex(() -> {
            if (fatalErrorsConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorsConsumer", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$new$2"));
            }
            return new VcsLogPathsIndex(logId, this.myRoots, fatalErrorsConsumer, this);
        });
        for (VirtualFile root : this.myRoots) {
            this.myNumberOfTasks.put(root, new AtomicInteger());
        }
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    public static int getVersion() {
        return 5;
    }

    @Nullable
    private <I extends VcsLogFullDetailsIndex> I createIndex(@NotNull ThrowableComputable<I, IOException> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createIndex"));
        }
        try {
            return (I)((VcsLogFullDetailsIndex)computable.compute());
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    @NotNull
    private <V> PersistentMap<Integer, V> createMap(@NotNull KeyDescriptor<V> descriptor, @NotNull String kind, @NotNull String logId, int version) {
        PersistentHashMap<Integer, V> persistentHashMap;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createMap"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createMap"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createMap"));
        }
        try {
            persistentHashMap = PersistentUtil.createPersistentHashMap(descriptor, kind, logId, version);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            InMemoryMap inMemoryMap = new InMemoryMap();
            if (inMemoryMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createMap"));
            }
            return inMemoryMap;
        }
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createMap"));
        }
        return persistentHashMap;
    }

    @Override
    public synchronized void scheduleIndex(boolean full) {
        if (this.myCommitsToIndex.isEmpty()) {
            return;
        }
        Map<VirtualFile, TIntHashSet> commitsToIndex = this.myCommitsToIndex;
        for (VirtualFile root : commitsToIndex.keySet()) {
            this.myNumberOfTasks.get(root).incrementAndGet();
        }
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        this.mySingleTaskController.request(new IndexingRequest(commitsToIndex, full));
    }

    private void storeDetail(@NotNull VcsFullCommitDetails detail, boolean flush) {
        if (detail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detail", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "storeDetail"));
        }
        try {
            int index = this.myHashMap.getCommitIndex((Hash)detail.getId(), detail.getRoot());
            this.myMessagesIndex.put((Object)index, (Object)detail.getFullMessage());
            if (this.myTrigramIndex != null) {
                this.myTrigramIndex.update(index, detail);
            }
            if (this.myUserIndex != null) {
                this.myUserIndex.update(index, detail);
            }
            if (this.myPathsIndex != null) {
                this.myPathsIndex.update(index, detail);
            }
            if (flush) {
                this.flush();
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    private void flush() {
        try {
            this.myMessagesIndex.force();
            if (this.myTrigramIndex != null) {
                this.myTrigramIndex.flush();
            }
            if (this.myUserIndex != null) {
                this.myUserIndex.flush();
            }
            if (this.myPathsIndex != null) {
                this.myPathsIndex.flush();
            }
        }
        catch (StorageException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    @Override
    public void markCorrupted() {
        if (this.myMessagesIndex instanceof PersistentHashMap) {
            ((PersistentHashMap)this.myMessagesIndex).markCorrupted();
        }
        if (this.myTrigramIndex != null) {
            this.myTrigramIndex.markCorrupted();
        }
        if (this.myUserIndex != null) {
            this.myUserIndex.markCorrupted();
        }
        if (this.myPathsIndex != null) {
            this.myPathsIndex.markCorrupted();
        }
    }

    @Override
    public boolean isIndexed(int commit) {
        try {
            return !(this.myMessagesIndex.get((Object)commit) == null || this.myUserIndex != null && !this.myUserIndex.isIndexed(commit) || this.myPathsIndex != null && !this.myPathsIndex.isIndexed(commit) || this.myTrigramIndex != null && !this.myTrigramIndex.isIndexed(commit));
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "isIndexed"));
        }
        return this.myRoots.contains(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "markForIndexing"));
        }
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        TIntHashSet set2 = this.myCommitsToIndex.get(root);
        if (set2 == null) {
            set2 = new TIntHashSet();
            this.myCommitsToIndex.put(root, set2);
        }
        set2.add(index);
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map, @NotNull Condition<T> condition) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        TIntHashSet result2 = new TIntHashSet();
        try {
            Processor processor2 = integer -> {
                if (map == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$filter$3"));
                }
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$filter$3"));
                }
                try {
                    Object value = map.get(integer);
                    if (value != null && condition.value(value)) {
                        result2.add(integer.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            };
            if (this.myMessagesIndex instanceof PersistentHashMap) {
                ((PersistentHashMap)this.myMessagesIndex).processKeysWithExistingMapping(processor2);
            } else {
                this.myMessagesIndex.processKeys(processor2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        if (users == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterUsers"));
        }
        if (this.myUserIndex != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myUserIndex.getCommitsForUsers(users);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterUsers"));
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterUsers"));
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterPaths"));
        }
        if (this.myPathsIndex != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myPathsIndex.getCommitsForPaths(paths);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterPaths"));
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterPaths"));
        }
        return tIntHashSet;
    }

    @NotNull
    public TIntHashSet filterMessages(@NotNull String text) {
        block12: {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
            }
            if (this.myTrigramIndex != null) {
                TIntHashSet tIntHashSet;
                block11: {
                    if (!VcsLogUtil.isRegexp(text)) break block11;
                    Pattern pattern = Pattern.compile(text);
                    TIntHashSet tIntHashSet2 = this.filter(this.myMessagesIndex, message -> pattern.matcher((CharSequence)message).find());
                    if (tIntHashSet2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
                    }
                    return tIntHashSet2;
                }
                try {
                    ValueContainer.IntIterator commitsForSearch = this.myTrigramIndex.getCommitsForSubstring(text);
                    if (commitsForSearch == null) break block12;
                    TIntHashSet result2 = new TIntHashSet();
                    while (commitsForSearch.hasNext()) {
                        int commit = commitsForSearch.next();
                        try {
                            String value = (String)this.myMessagesIndex.get((Object)commit);
                            if (value == null || !StringUtil.containsIgnoreCase((String)value, (String)text)) continue;
                            result2.add(commit);
                        }
                        catch (IOException e) {
                            this.myFatalErrorsConsumer.consume(this, e);
                            break;
                        }
                    }
                    tIntHashSet = result2;
                }
                catch (StorageException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                }
                if (tIntHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
                }
                return tIntHashSet;
            }
        }
        TIntHashSet tIntHashSet = this.filter(this.myMessagesIndex, message -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$filterMessages$5"));
            }
            return StringUtil.containsIgnoreCase((String)message, (String)text);
        });
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
        }
        return tIntHashSet;
    }

    @Override
    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "canFilter"));
        }
        if (filters.isEmpty()) {
            return false;
        }
        for (VcsLogDetailsFilter filter : filters) {
            if (filter instanceof VcsLogTextFilter && this.myTrigramIndex != null || filter instanceof VcsLogUserFilterImpl && this.myUserIndex != null || filter instanceof VcsLogStructureFilter && this.myPathsIndex != null) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilterImpl userFilter = (VcsLogUserFilterImpl)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilterImpl.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter.getText());
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile root : this.myRoots) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        Set<Integer> set2 = TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        return set2;
    }

    public void dispose() {
        try {
            this.myMessagesIndex.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void printDebugInfoForCommit(@NotNull CommitId commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "printDebugInfoForCommit"));
        }
        int commit = this.myHashMap.getCommitIndex(commitId.getHash(), commitId.getRoot());
        if (!this.isIndexed(commit)) {
            LOG.info("Commit " + commitId.getHash().asString() + " is not indexed.");
        } else {
            StringBuilder builder = new StringBuilder();
            try {
                builder.append("Commit ").append(commitId.getHash().asString()).append(" index info:\n");
                builder.append("Message:\n").append((String)this.myMessagesIndex.get((Object)commit)).append("\n");
                if (this.myTrigramIndex != null) {
                    builder.append("Trigrams:\n").append(this.myTrigramIndex.getTrigramInfo(commit)).append("\n");
                } else {
                    builder.append("Trigrams index is null");
                }
                if (this.myUserIndex != null) {
                    builder.append("User:\n").append(this.myUserIndex.getUserInfo(commit)).append("\n");
                } else {
                    builder.append("User index is null");
                }
                if (this.myPathsIndex != null) {
                    builder.append("Paths:\n").append(this.myPathsIndex.getPathInfo(commit)).append("\n");
                } else {
                    builder.append("Paths index is null");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            LOG.info(builder.toString());
        }
    }

    private static class CommitsCounter {
        @NotNull
        public final ProgressIndicator indicator;
        public final int allCommits;
        public volatile int newIndexedCommits;
        public volatile int oldCommits;

        private CommitsCounter(@NotNull ProgressIndicator indicator, int commits) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$CommitsCounter", "<init>"));
            }
            this.indicator = indicator;
            this.allCommits = commits;
        }

        public void displayProgress() {
            this.indicator.setFraction(((double)this.newIndexedCommits + (double)this.oldCommits) / (double)this.allCommits);
        }
    }

    private class IndexingRequest {
        private static final int MAGIC_NUMBER = 150000;
        private static final int BATCH_SIZE = 1000;
        private final Map<VirtualFile, TIntHashSet> myCommits;
        private final boolean myFull;

        public IndexingRequest(Map<VirtualFile, TIntHashSet> commits, boolean full) {
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "<init>"));
            }
            this.myCommits = commits;
            this.myFull = full;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "run"));
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            long time = System.currentTimeMillis();
            CommitsCounter counter = new CommitsCounter(indicator, this.myCommits.values().stream().mapToInt(THash::size).sum());
            LOG.debug("Indexing " + counter.allCommits + " commits");
            for (VirtualFile root : this.myCommits.keySet()) {
                try {
                    if (this.myFull) {
                        this.indexAll(root, this.myCommits.get(root), counter);
                        continue;
                    }
                    this.indexOneByOne(root, this.myCommits.get(root), counter);
                }
                finally {
                    ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(root)).decrementAndGet();
                }
            }
            LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - time) + " for indexing " + counter.newIndexedCommits + " new commits out of " + counter.allCommits);
            int leftCommits = counter.allCommits - counter.newIndexedCommits - counter.oldCommits;
            if (leftCommits > 0) {
                LOG.warn("Did not index " + leftCommits + " commits");
            }
        }

        private void indexOneByOne(@NotNull VirtualFile root, @NotNull TIntHashSet commitsSet, @NotNull CommitsCounter counter) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (commitsSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsSet", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (counter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            IntStream commits = TroveUtil.stream(commitsSet).filter(c -> {
                if (counter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$0"));
                }
                if (VcsLogPersistentIndex.this.isIndexed(c)) {
                    ++counter.oldCommits;
                    return false;
                }
                return true;
            });
            this.indexOneByOne(root, counter, commits);
        }

        private void indexOneByOne(@NotNull VirtualFile root, @NotNull CommitsCounter counter, @NotNull IntStream commits) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (counter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            TroveUtil.processBatches(commits, 1000, (Consumer<TIntHashSet>)((Consumer)batch -> {
                if (counter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$1"));
                }
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$1"));
                }
                counter.indicator.checkCanceled();
                if (this.indexOneByOne(root, (TIntHashSet)batch)) {
                    counter.newIndexedCommits += batch.size();
                }
                counter.displayProgress();
            }));
        }

        private boolean indexOneByOne(@NotNull VirtualFile root, @NotNull TIntHashSet commits) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            VcsLogProvider provider = (VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(root);
            try {
                List<String> hashes = TroveUtil.map(commits, value -> VcsLogPersistentIndex.this.myHashMap.getCommitId(value).getHash().asString());
                provider.readFullDetails(root, hashes, detail -> VcsLogPersistentIndex.this.storeDetail(detail, false));
                VcsLogPersistentIndex.this.flush();
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                commits.forEach(value -> {
                    if (root == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$4"));
                    }
                    VcsLogPersistentIndex.this.markForIndexing(value, root);
                    return true;
                });
                return false;
            }
            return true;
        }

        public void indexAll(@NotNull VirtualFile root, @NotNull TIntHashSet commitsSet, @NotNull CommitsCounter counter) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexAll"));
            }
            if (commitsSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsSet", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexAll"));
            }
            if (counter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexAll"));
            }
            TIntHashSet notIndexed = new TIntHashSet();
            TroveUtil.stream(commitsSet).forEach(c -> {
                if (counter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexAll$5"));
                }
                if (VcsLogPersistentIndex.this.isIndexed(c)) {
                    ++counter.oldCommits;
                } else {
                    notIndexed.add(c);
                }
            });
            counter.displayProgress();
            if (notIndexed.size() <= 150000) {
                this.indexOneByOne(root, counter, TroveUtil.stream(notIndexed));
            } else {
                try {
                    ((VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(root)).readAllFullDetails(root, details -> {
                        if (counter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexAll$6"));
                        }
                        int index = VcsLogPersistentIndex.this.myHashMap.getCommitIndex((Hash)details.getId(), details.getRoot());
                        if (notIndexed.contains(index)) {
                            VcsLogPersistentIndex.this.storeDetail(details, false);
                            ++counter.newIndexedCommits;
                        }
                        counter.indicator.checkCanceled();
                        counter.displayProgress();
                    });
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    notIndexed.forEach(value -> {
                        if (root == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexAll$7"));
                        }
                        VcsLogPersistentIndex.this.markForIndexing(value, root);
                        return true;
                    });
                }
            }
            VcsLogPersistentIndex.this.flush();
        }
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        public MySingleTaskController() {
            super(EmptyConsumer.getInstance());
        }

        @Override
        protected void startNewBackgroundTask() {
            ApplicationManager.getApplication().invokeLater(() -> {
                Task.Backgroundable task = new Task.Backgroundable(VcsLogPersistentIndex.this.myProject, "Indexing Commit Data", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                    public void run(@NotNull ProgressIndicator indicator) {
                        List requests;
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController$1", "run"));
                        }
                        while (!(requests = MySingleTaskController.this.popRequests()).isEmpty()) {
                            for (IndexingRequest request : requests) {
                                try {
                                    request.run(indicator);
                                }
                                catch (ProcessCanceledException reThrown) {
                                    throw reThrown;
                                }
                                catch (Throwable t) {
                                    LOG.error("Error while indexing", t);
                                }
                            }
                        }
                        MySingleTaskController.this.taskCompleted(null);
                    }
                };
                ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(false);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, indicator);
            });
        }
    }
}

