/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<Integer> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    private static final String NAME = "paths";
    private static final int VALUE = 239;
    @NotNull
    private final PersistentHashMap<Integer, Integer> myEmptyCommits;
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull String logId, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        if (fatalErrorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        super(logId, NAME, VcsLogPersistentIndex.getVersion(), new PathsIndexer(VcsLogPathsIndex.createPathsEnumerator(logId), roots), new NullableIntKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myEmptyCommits = PersistentUtil.createPersistentHashMap(EnumeratorIntegerDescriptor.INSTANCE, "index-no-paths", logId, VcsLogPersistentIndex.getVersion());
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> {
            if (fatalErrorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$new$0"));
            }
            fatalErrorHandler.consume(this, (Exception)e);
            this.markCorrupted();
        }));
    }

    @NotNull
    private static PersistentEnumeratorBase<String> createPathsEnumerator(@NotNull String logId) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "createPathsEnumerator"));
        }
        int version = VcsLogPersistentIndex.getVersion();
        File storageFile = PersistentUtil.getStorageFile("index-paths-ids", logId, version);
        PersistentBTreeEnumerator enumerator = (PersistentBTreeEnumerator)IOUtil.openCleanOrResetBroken(() -> new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)(SystemInfo.isFileSystemCaseSensitive ? EnumeratorStringDescriptor.INSTANCE : new ToLowerCaseStringDescriptor()), Page.PAGE_SIZE, null, version), () -> {
            if (logId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$createPathsEnumerator$2"));
            }
            IOUtil.deleteAllFilesStartingWith((File)VcsLogPathsIndex.getStorageFile("index-paths", logId, version));
            IOUtil.deleteAllFilesStartingWith((File)VcsLogPathsIndex.getStorageFile("index-inputs-paths", logId, version));
            IOUtil.deleteAllFilesStartingWith((File)storageFile);
        });
        if (enumerator == null) {
            throw new IOException("Can not create enumerator paths for " + logId);
        }
        PersistentBTreeEnumerator persistentBTreeEnumerator = enumerator;
        if (persistentBTreeEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "createPathsEnumerator"));
        }
        return persistentBTreeEnumerator;
    }

    @Override
    protected void onNotIndexableCommit(int commit) throws StorageException {
        try {
            this.myEmptyCommits.put((Object)commit, (Object)239);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean isIndexed(int commit) throws IOException {
        return super.isIndexed(commit) || this.myEmptyCommits.containsMapping((Object)commit);
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myEmptyCommits.force();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    public TIntHashSet getCommitsForPaths(@NotNull Collection<FilePath> paths) throws IOException, StorageException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getCommitsForPaths"));
        }
        HashSet allPathIds = ContainerUtil.newHashSet();
        for (FilePath path : paths) {
            allPathIds.add(this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path.getPath()));
        }
        TIntHashSet result2 = new TIntHashSet();
        Set<Object> renames = allPathIds;
        while (!renames.isEmpty()) {
            renames = this.addCommitsAndGetRenames(renames, allPathIds, result2);
            allPathIds.addAll(renames);
        }
        return result2;
    }

    @NotNull
    public Set<Integer> addCommitsAndGetRenames(@NotNull Set<Integer> newPathIds, @NotNull Set<Integer> allPathIds, @NotNull TIntHashSet commits) throws StorageException {
        if (newPathIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPathIds", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        if (allPathIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPathIds", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        HashSet renames = ContainerUtil.newHashSet();
        for (Integer key2 : newPathIds) {
            this.iterateCommitIdsAndValues(key2, (value, commit) -> {
                if (commits == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$addCommitsAndGetRenames$3"));
                }
                if (allPathIds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPathIds", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$addCommitsAndGetRenames$3"));
                }
                commits.add(commit);
                if (value != null && !allPathIds.contains(value)) {
                    renames.add(value);
                }
            });
        }
        HashSet hashSet = renames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        return hashSet;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myEmptyCommits.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        try {
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Override
    public void markCorrupted() {
        super.markCorrupted();
        this.myEmptyCommits.markCorrupted();
    }

    @NotNull
    public String getPathInfo(int commit) throws IOException {
        if (this.myEmptyCommits.containsMapping((Object)commit)) {
            if ("No paths" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getPathInfo"));
            }
            return "No paths";
        }
        Collection<Integer> keys = this.getKeysForCommit(commit);
        assert (keys != null);
        StringBuilder builder = new StringBuilder();
        for (int key2 : keys) {
            builder.append((String)this.myPathsIndexer.getPathsEnumerator().valueOf(key2)).append("\n");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getPathInfo"));
        }
        return string;
    }

    private static class ToLowerCaseStringDescriptor
    implements KeyDescriptor<String> {
        private ToLowerCaseStringDescriptor() {
        }

        public int getHashCode(String value) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.computeHashCode(value);
        }

        public boolean isEqual(String val1, String val2) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.equals(val1, val2);
        }

        public void save(@NotNull DataOutput out, String value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ToLowerCaseStringDescriptor", "save"));
            }
            IOUtil.writeUTF((DataOutput)out, (String)value.toLowerCase());
        }

        public String read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ToLowerCaseStringDescriptor", "read"));
            }
            return IOUtil.readUTF((DataInput)in);
        }
    }

    private static class NullableIntKeyDescriptor
    implements DataExternalizer<Integer> {
        private NullableIntKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$NullableIntKeyDescriptor", "save"));
            }
            if (value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(value);
            }
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$NullableIntKeyDescriptor", "read"));
            }
            if (in.readBoolean()) {
                return in.readInt();
            }
            return null;
        }
    }

    private static class PathsIndexer
    implements DataIndexer<Integer, Integer, VcsFullCommitDetails> {
        @NotNull
        private final PersistentEnumeratorBase<String> myPathsEnumerator;
        @NotNull
        private final Set<String> myRoots;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer;

        private PathsIndexer(@NotNull PersistentEnumeratorBase<String> enumerator, @NotNull Set<VirtualFile> roots) {
            if (enumerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerator", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "<init>"));
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myPathsEnumerator = enumerator;
            this.myRoots = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
            for (VirtualFile root : roots) {
                this.myRoots.add(root.getPath());
            }
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorConsumer", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "setFatalErrorConsumer"));
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, Integer> map(@NotNull VcsFullCommitDetails inputData) {
            Collection<Object> moves;
            HashSet changedPaths;
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "map"));
            }
            THashMap result2 = new THashMap();
            if (inputData instanceof VcsChangesLazilyParsedDetails) {
                changedPaths = ((VcsChangesLazilyParsedDetails)inputData).getModifiedPaths();
                moves = ((VcsChangesLazilyParsedDetails)inputData).getRenamedPaths();
            } else {
                moves = ContainerUtil.newHashSet();
                changedPaths = ContainerUtil.newHashSet();
                for (Change change : inputData.getChanges()) {
                    if (change.getAfterRevision() != null) {
                        changedPaths.add(change.getAfterRevision().getFile().getPath());
                    }
                    if (change.getBeforeRevision() != null) {
                        changedPaths.add(change.getBeforeRevision().getFile().getPath());
                    }
                    if (!change.getType().equals((Object)Change.Type.MOVED)) continue;
                    moves.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
                }
            }
            this.getParentPaths(changedPaths).forEach(arg_0 -> this.lambda$map$0((Map)result2, arg_0));
            moves.forEach(arg_0 -> this.lambda$map$1((Map)result2, arg_0));
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "map"));
            }
            return tHashMap;
        }

        @NotNull
        private Collection<String> getParentPaths(@NotNull Collection<String> paths) {
            if (paths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VcsLogPathsIndex.NAME, "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getParentPaths"));
            }
            HashSet result2 = ContainerUtil.newHashSet();
            block0: for (String path : paths) {
                while (!path.isEmpty() && !result2.contains(path)) {
                    result2.add(path);
                    if (this.myRoots.contains(path)) continue block0;
                    path = PathUtil.getParentPath((String)path);
                }
            }
            HashSet hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getParentPaths"));
            }
            return hashSet;
        }

        @NotNull
        public PersistentEnumeratorBase<String> getPathsEnumerator() {
            PersistentEnumeratorBase<String> persistentEnumeratorBase = this.myPathsEnumerator;
            if (persistentEnumeratorBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getPathsEnumerator"));
            }
            return persistentEnumeratorBase;
        }

        private /* synthetic */ void lambda$map$1(Map result2, Couple renamedPaths) {
            try {
                int beforeId = this.myPathsEnumerator.enumerate(renamedPaths.first);
                int afterId = this.myPathsEnumerator.enumerate(renamedPaths.second);
                result2.put(beforeId, afterId);
                result2.put(afterId, beforeId);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }

        private /* synthetic */ void lambda$map$0(Map result2, String changedPath) {
            try {
                result2.put(this.myPathsEnumerator.enumerate((Object)changedPath), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }
    }
}

