/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolderImpl;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.DomHighlightingHelperImpl;
import com.intellij.util.xml.highlighting.MockAnnotatingDomInspection;
import com.intellij.util.xml.highlighting.MockDomInspection;
import com.intellij.util.xml.impl.DomApplicationComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationsManagerImpl
extends DomElementAnnotationsManager {
    public static final Object LOCK = new Object();
    private static final Key<DomElementsProblemsHolderImpl> DOM_PROBLEM_HOLDER_KEY = Key.create((String)"DomProblemHolder");
    private static final Key<CachedValue<Boolean>> CACHED_VALUE_KEY = Key.create((String)"DomProblemHolderCachedValue");
    private final EventDispatcher<DomElementAnnotationsManager.DomHighlightingListener> myDispatcher = EventDispatcher.create(DomElementAnnotationsManager.DomHighlightingListener.class);
    private static final DomElementsProblemsHolder EMPTY_PROBLEMS_HOLDER = new DomElementsProblemsHolder(){

        @NotNull
        public List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
            List<DomElementProblemDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1", "getProblems"));
            }
            return list;
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren, HighlightSeverity minSeverity) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems() {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
            if (inspection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspection", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1", "getAllProblems"));
            }
            return Collections.emptyList();
        }

        public boolean isInspectionCompleted(@NotNull DomElementsInspection inspectionClass) {
            if (inspectionClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1", "isInspectionCompleted"));
            }
            return false;
        }
    };
    private final Project myProject;

    public DomElementAnnotationsManagerImpl(Project project2) {
        this.myProject = project2;
        ProfileChangeAdapter profileChangeAdapter = new ProfileChangeAdapter(){

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            public void profileChanged(InspectionProfile profile) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        };
        InspectionProfileManager.getInstance().addProfileChangeListener(profileChangeAdapter, (Disposable)project2);
    }

    public void dropAnnotationsCache() {
        this.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DomElementProblemDescriptor> appendProblems(@NotNull DomFileElement element, @NotNull DomElementAnnotationHolder annotationHolder, Class<? extends DomElementsInspection> inspectionClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "appendProblems"));
        }
        if (annotationHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationHolder", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "appendProblems"));
        }
        DomElementAnnotationHolderImpl holderImpl = (DomElementAnnotationHolderImpl)annotationHolder;
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolderImpl holder = this._getOrCreateProblemsHolder(element);
            holder.appendProblems(holderImpl, inspectionClass);
        }
        ((DomElementAnnotationsManager.DomHighlightingListener)this.myDispatcher.getMulticaster()).highlightingFinished(element);
        return Collections.unmodifiableList(holderImpl);
    }

    private DomElementsProblemsHolderImpl _getOrCreateProblemsHolder(DomFileElement element) {
        DomElement rootElement = element.getRootElement();
        XmlTag rootTag = rootElement.getXmlTag();
        if (rootTag == null) {
            return new DomElementsProblemsHolderImpl(element);
        }
        DomElementsProblemsHolderImpl holder = (DomElementsProblemsHolderImpl)rootTag.getUserData(DOM_PROBLEM_HOLDER_KEY);
        if (DomElementAnnotationsManagerImpl.isHolderOutdated(element.getFile()) || holder == null) {
            holder = new DomElementsProblemsHolderImpl(element);
            rootTag.putUserData(DOM_PROBLEM_HOLDER_KEY, (Object)holder);
            CachedValue cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> new CachedValueProvider.Result((Object)Boolean.FALSE, new Object[]{element, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this, ProjectRootManager.getInstance((Project)this.myProject)}), false);
            cachedValue.getValue();
            element.getFile().putUserData(CACHED_VALUE_KEY, (Object)cachedValue);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHolderUpToDate(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            return !DomElementAnnotationsManagerImpl.isHolderOutdated(DomUtil.getFile((DomElement)element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outdateProblemHolder(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            DomUtil.getFile((DomElement)element).putUserData(CACHED_VALUE_KEY, null);
        }
    }

    private static boolean isHolderOutdated(XmlFile file2) {
        CachedValue cachedValue = (CachedValue)file2.getUserData(CACHED_VALUE_KEY);
        return cachedValue == null || !cachedValue.hasUpToDateValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DomElementsProblemsHolder getProblemHolder(DomElement element) {
        DomElementsProblemsHolder readyHolder;
        if (element == null || !element.isValid()) {
            DomElementsProblemsHolder domElementsProblemsHolder = EMPTY_PROBLEMS_HOLDER;
            if (domElementsProblemsHolder != null) return domElementsProblemsHolder;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "getProblemHolder"));
        }
        DomFileElement fileElement = DomUtil.getFileElement((DomElement)element);
        Object object = LOCK;
        // MONITORENTER : object
        XmlTag tag = fileElement.getRootElement().getXmlTag();
        if (tag != null && (readyHolder = (DomElementsProblemsHolder)tag.getUserData(DOM_PROBLEM_HOLDER_KEY)) != null) {
            DomElementsProblemsHolder domElementsProblemsHolder = readyHolder;
            // MONITOREXIT : object
            if (domElementsProblemsHolder != null) return domElementsProblemsHolder;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "getProblemHolder"));
        }
        DomElementsProblemsHolder domElementsProblemsHolder = EMPTY_PROBLEMS_HOLDER;
        // MONITOREXIT : object
        if (domElementsProblemsHolder != null) return domElementsProblemsHolder;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "getProblemHolder"));
    }

    @NotNull
    public DomElementsProblemsHolder getCachedProblemHolder(DomElement element) {
        DomElementsProblemsHolder domElementsProblemsHolder = this.getProblemHolder(element);
        if (domElementsProblemsHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "getCachedProblemHolder"));
        }
        return domElementsProblemsHolder;
    }

    public static void annotate(DomElement element, DomElementAnnotationHolder holder, Class rootClass) {
        DomElementsAnnotator annotator2 = DomApplicationComponent.getInstance().getAnnotator(rootClass);
        if (annotator2 != null) {
            annotator2.annotate(element, holder);
        }
    }

    public List<ProblemDescriptor> createProblemDescriptors(InspectionManager manager, DomElementProblemDescriptor problemDescriptor) {
        return ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createProblemDescriptors(manager, problemDescriptor));
    }

    public boolean isHighlightingFinished(DomElement[] domElements) {
        for (DomElement domElement : domElements) {
            if (this.getHighlightStatus(domElement) == DomHighlightStatus.INSPECTIONS_FINISHED) continue;
            return false;
        }
        return true;
    }

    public void addHighlightingListener(DomElementAnnotationsManager.DomHighlightingListener listener2, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public DomHighlightingHelper getHighlightingHelper() {
        return DomHighlightingHelperImpl.INSTANCE;
    }

    @NotNull
    public <T extends DomElement> List<DomElementProblemDescriptor> checkFileElement(@NotNull DomFileElement<T> domFileElement, @NotNull DomElementsInspection<T> inspection, boolean onTheFly) {
        if (domFileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domFileElement", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "checkFileElement"));
        }
        if (inspection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspection", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "checkFileElement"));
        }
        DomElementsProblemsHolder problemHolder = this.getProblemHolder((DomElement)domFileElement);
        if (DomElementAnnotationsManagerImpl.isHolderUpToDate(domFileElement) && problemHolder.isInspectionCompleted(inspection)) {
            List list = problemHolder.getAllProblems(inspection);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "checkFileElement"));
            }
            return list;
        }
        DomElementAnnotationHolderImpl holder = new DomElementAnnotationHolderImpl(onTheFly);
        inspection.checkFileElement(domFileElement, (DomElementAnnotationHolder)holder);
        List<DomElementProblemDescriptor> list = this.appendProblems(domFileElement, holder, inspection.getClass());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "checkFileElement"));
        }
        return list;
    }

    public List<DomElementsInspection> getSuitableDomInspections(DomFileElement fileElement, boolean enabledOnly) {
        Class rootType = fileElement.getRootElementClass();
        InspectionProfile profile = this.getInspectionProfile(fileElement);
        SmartList inspections = new SmartList();
        for (InspectionToolWrapper toolWrapper : profile.getInspectionTools((PsiElement)fileElement.getFile())) {
            if (enabledOnly && !profile.isToolEnabled(HighlightDisplayKey.find((String)toolWrapper.getShortName()), (PsiElement)fileElement.getFile())) continue;
            ContainerUtil.addIfNotNull((Collection)inspections, (Object)DomElementAnnotationsManagerImpl.getSuitableInspection(toolWrapper.getTool(), rootType));
        }
        return inspections;
    }

    protected InspectionProfile getInspectionProfile(DomFileElement fileElement) {
        return InspectionProjectProfileManager.getInstance(fileElement.getManager().getProject()).getCurrentProfile();
    }

    @Nullable
    private static DomElementsInspection getSuitableInspection(InspectionProfileEntry entry, Class rootType) {
        if (entry instanceof DomElementsInspection && ((DomElementsInspection)entry).getDomClasses().contains(rootType)) {
            return (DomElementsInspection)entry;
        }
        return null;
    }

    @Nullable
    public <T extends DomElement> DomElementsInspection<T> getMockInspection(DomFileElement<T> root) {
        if (root.getFileDescription().isAutomaticHighlightingEnabled()) {
            return new MockAnnotatingDomInspection(root.getRootElementClass());
        }
        if (this.getSuitableDomInspections(root, false).isEmpty()) {
            return new MockDomInspection(root.getRootElementClass());
        }
        return null;
    }

    private static boolean areInspectionsFinished(DomElementsProblemsHolderImpl holder, List<DomElementsInspection> suitableInspections) {
        for (DomElementsInspection inspection : suitableInspections) {
            if (holder.isInspectionCompleted(inspection)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DomHighlightStatus getHighlightStatus(DomElement element) {
        DomElementsProblemsHolder holder;
        Object object = LOCK;
        // MONITORENTER : object
        DomFileElement root = DomUtil.getFileElement((DomElement)element);
        if (!DomElementAnnotationsManagerImpl.isHolderOutdated(root.getFile()) && (holder = this.getProblemHolder(element)) instanceof DomElementsProblemsHolderImpl) {
            DomElementsProblemsHolderImpl holderImpl = (DomElementsProblemsHolderImpl)holder;
            List<DomElementsInspection> suitableInspections = this.getSuitableDomInspections(root, true);
            DomElementsInspection mockInspection = this.getMockInspection(root);
            boolean annotatorsFinished = mockInspection == null || holderImpl.isInspectionCompleted(mockInspection);
            boolean inspectionsFinished = DomElementAnnotationsManagerImpl.areInspectionsFinished(holderImpl, suitableInspections);
            if (annotatorsFinished) {
                if (!suitableInspections.isEmpty() && !inspectionsFinished) {
                    DomHighlightStatus domHighlightStatus = DomHighlightStatus.ANNOTATORS_FINISHED;
                    // MONITOREXIT : object
                    if (domHighlightStatus != null) return domHighlightStatus;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "getHighlightStatus"));
                }
                DomHighlightStatus domHighlightStatus = DomHighlightStatus.INSPECTIONS_FINISHED;
                // MONITOREXIT : object
                if (domHighlightStatus != null) return domHighlightStatus;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "getHighlightStatus"));
            }
        }
        DomHighlightStatus domHighlightStatus = DomHighlightStatus.NONE;
        // MONITOREXIT : object
        if (domHighlightStatus != null) return domHighlightStatus;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl", "getHighlightStatus"));
    }
}

