/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ListItemEditor;
import gnu.trove.TObjectObjectProcedure;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListModelEditorBase<T>
extends CollectionModelEditor<T, ListItemEditor<T>> {
    protected final MyModel model;

    public ListModelEditorBase(@NotNull ListItemEditor<T> itemEditor) {
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/ListModelEditorBase", "<init>"));
        }
        super(itemEditor);
        this.model = new MyModel();
    }

    @NotNull
    public CollectionListModel<T> getModel() {
        MyModel myModel = this.model;
        if (myModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditorBase", "getModel"));
        }
        return myModel;
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        List list = this.model.items();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditorBase", "getItems"));
        }
        return list;
    }

    @Override
    public void reset(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListModelEditorBase", "reset"));
        }
        super.reset(items);
        this.model.replaceAll(items);
    }

    public final void ensureNonEmptyNames(@NotNull String errorMessage) throws ConfigurationException {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/util/ui/ListModelEditorBase", "ensureNonEmptyNames"));
        }
        List<T> items = this.getItems();
        for (int i2 = items.size() - 1; i2 >= 0; --i2) {
            T item = items.get(i2);
            if (!StringUtil.isEmptyOrSpaces((String)((ListItemEditor)this.itemEditor).getName(item))) continue;
            if (((ListItemEditor)this.itemEditor).isEmpty(item)) {
                this.removeEmptyItem(i2);
                continue;
            }
            throw new ConfigurationException(errorMessage);
        }
    }

    protected void removeEmptyItem(int i2) {
    }

    @Override
    protected boolean isEditable(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/ListModelEditorBase", "isEditable"));
        }
        return ((ListItemEditor)this.itemEditor).isEditable(item);
    }

    @NotNull
    public List<T> apply() {
        List<T> items = this.getItems();
        if (!this.helper.hasModifiedItems()) {
            List<T> list = items;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditorBase", "apply"));
            }
            return list;
        }
        this.helper.process(new TObjectObjectProcedure<T, T>(){

            public boolean execute(T newItem, T oldItem) {
                ((ListItemEditor)ListModelEditorBase.this.itemEditor).applyModifiedProperties(newItem, oldItem);
                ListModelEditorBase.this.silentlyReplaceItem(newItem, oldItem, -1);
                return true;
            }
        });
        this.helper.reset(items);
        List<T> list = items;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditorBase", "apply"));
        }
        return list;
    }

    @Override
    protected void silentlyReplaceItem(@NotNull T oldItem, @NotNull T newItem, int index) {
        if (oldItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/util/ui/ListModelEditorBase", "silentlyReplaceItem"));
        }
        if (newItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/util/ui/ListModelEditorBase", "silentlyReplaceItem"));
        }
        super.silentlyReplaceItem(oldItem, newItem, index);
        this.model.checkSelectionOnSilentReplace(oldItem, newItem);
    }

    protected final class MyModel
    extends MutableCollectionComboBoxModel<T> {
        protected MyModel() {
        }

        @NotNull
        final List<T> items() {
            List list = super.getInternalList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditorBase$MyModel", "items"));
            }
            return list;
        }

        void checkSelectionOnSilentReplace(@NotNull T oldItem, @NotNull T newItem) {
            if (oldItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/util/ui/ListModelEditorBase$MyModel", "checkSelectionOnSilentReplace"));
            }
            if (newItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/util/ui/ListModelEditorBase$MyModel", "checkSelectionOnSilentReplace"));
            }
            if (this.mySelection == oldItem) {
                this.mySelection = newItem;
            }
        }

        protected void itemReplaced(@NotNull T existingItem, @Nullable T newItem) {
            if (existingItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingItem", "com/intellij/util/ui/ListModelEditorBase$MyModel", "itemReplaced"));
            }
            ListModelEditorBase.this.helper.remove(existingItem);
        }

        public void removeAll() {
            super.removeAll();
            ListModelEditorBase.this.helper.reset(null);
        }
    }
}

