/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.wizard;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.wizard.WizardCallback;
import com.intellij.ui.wizard.WizardModel;
import com.intellij.ui.wizard.WizardNavigationState;
import com.intellij.ui.wizard.WizardStep;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class WizardDialog<T extends WizardModel>
extends DialogWrapper
implements WizardCallback {
    protected final T myModel;
    private final JButton myPrevious = new JButton();
    private final JButton myNext = new JButton();
    private final JButton myFinish = new JButton();
    private final JButton myCancel = new JButton();
    private final JButton myHelp = new JButton();
    private final JLabel myIcon = new JLabel();
    private final JLabel myHeader = new JLabel();
    private final JLabel myExplanation = new MultiLineLabel();
    private JPanel myStepContent;
    private CardLayout myCardLayout;
    private final Map<WizardStep, String> myStepCardNames = new HashMap<WizardStep, String>();

    public WizardDialog(Project project2, boolean canBeParent, T model) {
        super(project2, canBeParent);
        this.myModel = model;
        this.init();
    }

    public WizardDialog(boolean canBeParent, T model) {
        super(canBeParent);
        this.myModel = model;
        this.init();
    }

    public WizardDialog(boolean canBeParent, boolean tryApplicationModal, T model) {
        super(null, canBeParent, tryApplicationModal);
        this.myModel = model;
        this.init();
    }

    public WizardDialog(Component parent, boolean canBeParent, T model) {
        super(parent, canBeParent);
        this.myModel = model;
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel result2 = new JPanel(new BorderLayout());
        JPanel icon = new JPanel(new BorderLayout());
        icon.add((Component)this.myIcon, "North");
        result2.add((Component)icon, "West");
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        header.add(this.myHeader);
        header.add(Box.createVerticalStrut(4));
        header.add(this.myExplanation);
        header.add(Box.createVerticalStrut(4));
        header.add((Component)new SeparatorComponent(0, Color.gray, null));
        header.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.add((Component)header, "North");
        this.myCardLayout = new CardLayout();
        this.myStepContent = new JPanel(this.myCardLayout){

            @Override
            public Dimension getPreferredSize() {
                Dimension custom = WizardDialog.this.getWindowPreferredSize();
                Dimension superSize = super.getPreferredSize();
                if (custom != null) {
                    custom.width = custom.width > 0 ? custom.width : superSize.width;
                    custom.height = custom.height > 0 ? custom.height : superSize.height;
                } else {
                    custom = superSize;
                }
                return custom;
            }
        };
        content.add((Component)header, "North");
        content.add((Component)this.myStepContent, "Center");
        result2.add((Component)content, "Center");
        return result2;
    }

    protected void init() {
        this.setTitle(((WizardModel)this.myModel).getTitle());
        this.initHelpButton();
        ((WizardModel)this.myModel).setCallback(this);
        super.init();
        this.initCurrentStep();
    }

    private void initHelpButton() {
        this.myHelp.setText("Help");
        this.myHelp.setMnemonic('H');
        this.myHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.onHelp();
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.onHelp();
            }
        }, KeyStroke.getKeyStroke(112, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.onHelp();
            }
        }, KeyStroke.getKeyStroke(156, 0), 2);
    }

    private void onHelp() {
        HelpManager.getInstance().invokeHelp(((WizardModel)this.myModel).getCurrentStep().getHelpId());
    }

    private void initCurrentStep() {
        WizardStep current = ((WizardModel)this.myModel).getCurrentStep();
        this.myIcon.setIcon(current.getIcon());
        this.myHeader.setFont(this.myHeader.getFont().deriveFont(1, 14.0f));
        this.myHeader.setText(current.getTitle());
        this.myExplanation.setText(current.getExplanation());
        String stepName = this.myStepCardNames.get(current);
        if (stepName == null) {
            stepName = "Step" + this.myStepCardNames.size();
            this.myStepContent.add((Component)((WizardModel)this.myModel).getCurrentComponent(), stepName);
            this.myStepCardNames.put(current, stepName);
        }
        this.myCardLayout.show(this.myStepContent, stepName);
        WizardNavigationState state = ((WizardModel)this.myModel).getCurrentNavigationState();
        this.myPrevious.setAction(state.PREVIOUS);
        this.myNext.setAction(state.NEXT);
        this.myFinish.setAction(state.FINISH);
        this.myCancel.setAction(state.CANCEL);
        if (this.myNext.isEnabled()) {
            this.getRootPane().setDefaultButton(this.myNext);
        } else if (this.myFinish.isEnabled()) {
            this.getRootPane().setDefaultButton(this.myFinish);
            this.myFinish.requestFocusInWindow();
        } else if (this.myCancel.isEnabled()) {
            this.getRootPane().setDefaultButton(this.myCancel);
        } else {
            this.getRootPane().setDefaultButton(null);
        }
        JComponent focusComponent = current.getPreferredFocusedComponent();
        if (focusComponent != null) {
            focusComponent.requestFocusInWindow();
        }
    }

    protected JComponent createSouthPanel() {
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new GridLayout(1, 0, 5, 0));
        panel2.add(this.myPrevious);
        panel2.add(this.myNext);
        panel2.add(this.myFinish);
        panel2.add(this.myCancel);
        if (ApplicationManager.getApplication() != null) {
            panel2.add(this.myHelp);
        }
        southPanel.add((Component)panel2, "East");
        southPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        return southPanel;
    }

    @Override
    public void onStepChanged() {
        this.initCurrentStep();
    }

    @Override
    public void onWizardGoalDropped() {
        this.doCancelAction();
    }

    @Override
    public void onWizardGoalAchieved() {
        this.doOKAction();
    }

    public boolean isWizardGoalAchieved() {
        return this.isOK();
    }

    protected Dimension getWindowPreferredSize() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return ((WizardModel)this.myModel).getCurrentStep().getPreferredFocusedComponent();
    }
}

