/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextAccessor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ReferenceEditorWithBrowseButton
extends ComponentWithBrowseButton<EditorTextField>
implements TextAccessor {
    private final Function<String, Document> myFactory;
    private final List<DocumentListener> myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public ReferenceEditorWithBrowseButton(ActionListener browseActionListener, Project project2, Function<String, Document> factory, String text) {
        this(browseActionListener, new EditorTextField((Document)factory.fun((Object)text), project2, (FileType)StdFileTypes.JAVA), factory);
    }

    public ReferenceEditorWithBrowseButton(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory) {
        super((JComponent)((Object)editorTextField), browseActionListener);
        this.myFactory = factory;
    }

    public void addDocumentListener(DocumentListener listener2) {
        this.myDocumentListeners.add(listener2);
        this.getEditorTextField().getDocument().addDocumentListener(listener2);
    }

    public void removeDocumentListener(DocumentListener listener2) {
        this.myDocumentListeners.remove(listener2);
        this.getEditorTextField().getDocument().removeDocumentListener(listener2);
    }

    public EditorTextField getEditorTextField() {
        return (EditorTextField)((Object)this.getChildComponent());
    }

    public String getText() {
        return this.getEditorTextField().getText().trim();
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/ReferenceEditorWithBrowseButton", "setText"));
        }
        Document oldDocument = this.getEditorTextField().getDocument();
        String oldText = oldDocument.getText();
        for (DocumentListener listener2 : this.myDocumentListeners) {
            oldDocument.removeDocumentListener(listener2);
        }
        Document document = (Document)this.myFactory.fun((Object)text);
        this.getEditorTextField().setDocument(document);
        for (DocumentListener listener3 : this.myDocumentListeners) {
            document.addDocumentListener(listener3);
            listener3.documentChanged((DocumentEvent)new DocumentEventImpl(document, 0, oldText, text, -1L, false));
        }
    }

    public boolean isEditable() {
        return !this.getEditorTextField().getEditor().isViewer();
    }
}

