/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.ConfigurationsCollector;
import com.intellij.testIntegration.RecentTestsDataKt;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SingleTestCollector;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SingleTestInfo;
import com.intellij.testIntegration.SuiteEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/testIntegration/RecentTestsData;", "", "()V", "runConfigurationSuites", "Ljava/util/HashMap;", "", "Lcom/intellij/testIntegration/RunConfigurationEntry;", "testsWithoutSuites", "Ljava/util/ArrayList;", "Lcom/intellij/testIntegration/SingleTestInfo;", "addSuite", "", "suite", "Lcom/intellij/testIntegration/SuiteEntry;", "addTest", "test", "Lcom/intellij/testIntegration/SingleTestEntry;", "findRunConfigurationSuite", "url", "runConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getFailedTests", "", "allConfigurations", "", "getTestsToShow", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "moveSuiteTestsToSuite", "execution-impl"})
public final class RecentTestsData {
    private final HashMap<String, RunConfigurationEntry> runConfigurationSuites = MapsKt.hashMapOf((Pair[])new Pair[0]);
    private ArrayList<SingleTestInfo> testsWithoutSuites = CollectionsKt.arrayListOf((Object[])new SingleTestInfo[0]);

    public final void addSuite(@NotNull SuiteEntry suite) {
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        this.moveSuiteTestsToSuite(suite);
        String id = suite.getRunConfiguration().getUniqueID();
        RunConfigurationEntry entry = this.runConfigurationSuites.get(id);
        if (entry != null) {
            entry.addSuite(suite);
        } else {
            RunConfigurationEntry configurationEntry = new RunConfigurationEntry(suite.getRunConfiguration());
            configurationEntry.addSuite(suite);
            this.runConfigurationSuites.put(id, configurationEntry);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void moveSuiteTestsToSuite(SuiteEntry suite) {
        void $receiver$iv;
        RunnerAndConfigurationSettings suiteConfiguration = suite.getRunConfiguration();
        ArrayList filteredTests = CollectionsKt.arrayListOf((Object[])new SingleTestInfo[0]);
        Iterable iterable = this.testsWithoutSuites;
        for (Object element$iv : $receiver$iv) {
            SingleTestInfo it = (SingleTestInfo)element$iv;
            if (RecentTestsDataKt.isMyTest(suite, it.getTest()) && Intrinsics.areEqual((Object)suiteConfiguration.getName(), (Object)it.getRunConfigurationName())) {
                suite.addTest(it.getTest());
                continue;
            }
            filteredTests.add(it);
        }
        this.testsWithoutSuites = filteredTests;
    }

    public final void addTest(@NotNull SingleTestEntry test) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        SuiteEntry suiteEntry = this.findRunConfigurationSuite(test.getUrl(), test.getRunConfiguration());
        if (suiteEntry != null) {
            suiteEntry.addTest(test);
        } else {
            String string = test.getRunConfiguration().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"test.runConfiguration.name");
            this.testsWithoutSuites.add(new SingleTestInfo(test, string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SuiteEntry findRunConfigurationSuite(String url, RunnerAndConfigurationSettings runConfiguration) {
        void $receiver$iv;
        RunConfigurationEntry runConfigurationEntry = this.runConfigurationSuites.get(runConfiguration.getUniqueID());
        if (runConfigurationEntry == null) {
            return null;
        }
        RunConfigurationEntry pack = runConfigurationEntry;
        String testName = VirtualFileManager.extractPath((String)url);
        Iterable iterable = pack.getSuites();
        for (Object element$iv : $receiver$iv) {
            SuiteEntry it = (SuiteEntry)element$iv;
            String string = it.getSuiteName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.suiteName");
            if (!StringsKt.startsWith$default((String)testName, (String)string, (boolean)false, (int)2, null)) continue;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RecentTestsPopupEntry> getTestsToShow() {
        SingleTestEntry it;
        List list;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        void destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        Object it2;
        Object element$iv2;
        void $receiver$iv3;
        Collection<RunConfigurationEntry> allConfigurations;
        Collection<RunConfigurationEntry> collection = allConfigurations = this.runConfigurationSuites.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"allConfigurations");
        List<SingleTestEntry> failedTests = this.getFailedTests(collection);
        ConfigurationsCollector configsCollector = new ConfigurationsCollector();
        Iterable iterable = allConfigurations;
        for (Object element$iv2 : $receiver$iv3) {
            it2 = (RunConfigurationEntry)element$iv2;
            ((RunConfigurationEntry)it2).accept(configsCollector);
        }
        Iterable iterable2 = configsCollector.getEntries();
        element$iv2 = $receiver$iv2;
        it2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            RecentTestsPopupEntry it3 = (RecentTestsPopupEntry)element$iv$iv;
            if (!(!it3.getFailed())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List passedConfigurations = (List)destination$iv$iv2;
        $receiver$iv$iv2 = this.testsWithoutSuites;
        Collection collection2 = CollectionsKt.plus((Collection)failedTests, (Iterable)passedConfigurations);
        destination$iv$iv2 = $receiver$iv;
        Collection $i$a$1$forEach = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            SingleTestInfo $i$a$1$filter = (SingleTestInfo)item$iv$iv;
            list = destination$iv$iv;
            SingleTestEntry singleTestEntry = ((SingleTestInfo)((Object)it)).getTest();
            list.add(singleTestEntry);
        }
        list = (List)destination$iv$iv;
        $receiver$iv = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (SingleTestEntry)element$iv$iv;
            if (!it.getFailed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        List entriesToShow = CollectionsKt.plus((Collection)collection2, (Iterable)list);
        $receiver$iv = entriesToShow;
        Iterable iterable3 = $receiver$iv;
        Comparator comparator2 = new Comparator<RecentTestsPopupEntry>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                RecentTestsPopupEntry it = (RecentTestsPopupEntry)b;
                Comparable comparable = it.getRunDate();
                it = (RecentTestsPopupEntry)a;
                Comparable comparable2 = comparable;
                Date date = it.getRunDate();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)date);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable3, (Comparator)comparator2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SingleTestEntry> getFailedTests(Collection<RunConfigurationEntry> allConfigurations) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object it;
        Object element$iv2;
        SingleTestCollector testsCollector = new SingleTestCollector();
        Iterable $receiver$iv2 = allConfigurations;
        for (Object element$iv2 : $receiver$iv2) {
            it = (RunConfigurationEntry)element$iv2;
            ((RunConfigurationEntry)it).accept(testsCollector);
        }
        Iterable iterable = testsCollector.getTests();
        element$iv2 = $receiver$iv;
        it = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SingleTestEntry it2 = (SingleTestEntry)element$iv$iv;
            if (!it2.getFailed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List failedTests = (List)destination$iv$iv;
        return failedTests;
    }
}

