/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\"\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "relativePath", "data", "testFramework"})
public final class TemporaryDirectoryKt {
    @NotNull
    public static final Path generateTemporaryPath(@Nullable String fileName) {
        Path tempDirectory = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
        Path path = tempDirectory.resolve(fileName);
        for (int i2 = 0; PathKt.exists(path) && i2 < 9; ++i2) {
            path = tempDirectory.resolve(fileName + "_" + i2);
        }
        if (PathKt.exists(path)) {
            throw (Throwable)new IOException("Cannot generate unique random path");
        }
        Path path2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        return path2;
    }

    public static final VirtualFile writeChild(@NotNull VirtualFile $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return VfsTestUtil.createFile($receiver, relativePath, data);
    }
}

