/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchPredicateProvider;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.DeleteNodesAction;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.StringToConstraintsTransformer;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.BinaryPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ContainsPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ReferencePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.impl.matcher.predicates.WithinPredicate;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternCompiler {
    private static CompileContext lastTestingContext;

    public static void transformOldPattern(MatchOptions options) {
        StringToConstraintsTransformer.transformOldPattern(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledPattern compilePattern(Project project2, MatchOptions options) throws MalformedPatternException, UnsupportedOperationException {
        FileType fileType = options.getFileType();
        assert (fileType instanceof LanguageFileType);
        Language language = ((LanguageFileType)fileType).getLanguage();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByLanguage(language);
        assert (profile != null);
        CompiledPattern result2 = profile.createCompiledPattern();
        String[] prefixes = result2.getTypedVarPrefixes();
        assert (prefixes.length > 0);
        CompileContext context = new CompileContext();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            lastTestingContext = context;
        }
        try {
            context.init(result2, options, project2, options.getScope() instanceof GlobalSearchScope);
            List<PsiElement> elements = PatternCompiler.compileByAllPrefixes(project2, options, result2, context, prefixes);
            CompiledPattern pattern = context.getPattern();
            PatternCompiler.checkForUnknownVariables(pattern, elements);
            pattern.setNodes(elements);
            if (context.getSearchHelper().doOptimizing() && context.getSearchHelper().isScannedSomething()) {
                Set<PsiFile> set2 = context.getSearchHelper().getFilesSetToScan();
                ArrayList<PsiFile> filesToScan = new ArrayList<PsiFile>(set2.size());
                GlobalSearchScope scope = (GlobalSearchScope)options.getScope();
                for (PsiFile file2 : set2) {
                    if (!scope.contains(file2.getVirtualFile())) continue;
                    if (file2 instanceof PsiFileImpl) {
                        ((PsiFileImpl)file2).clearCaches();
                    }
                    filesToScan.add(file2);
                }
                if (filesToScan.size() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("ssr.will.not.find.anything", new Object[0]));
                }
                result2.setScope((SearchScope)new LocalSearchScope(PsiUtilCore.toPsiElementArray(filesToScan)));
            }
        }
        finally {
            context.clear();
        }
        return result2;
    }

    private static void checkForUnknownVariables(final CompiledPattern pattern, List<PsiElement> elements) {
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (element.getUserData(CompiledPattern.HANDLER_KEY) != null) {
                        return;
                    }
                    super.visitElement(element);
                    if (!(element instanceof LeafElement) || !pattern.isTypedVar(element)) {
                        return;
                    }
                    MatchingHandler handler2 = pattern.getHandler(pattern.getTypedVarString(element));
                    if (handler2 == null) {
                        throw new MalformedPatternException();
                    }
                }
            });
        }
    }

    public static String getLastFindPlan() {
        return ((TestModeOptimizingSearchHelper)lastTestingContext.getSearchHelper()).getSearchPlan();
    }

    @NotNull
    private static List<PsiElement> compileByAllPrefixes(Project project2, MatchOptions options, CompiledPattern pattern, CompileContext context, String[] applicablePrefixes) {
        if (applicablePrefixes.length == 0) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        List<PsiElement> elements = PatternCompiler.doCompile(project2, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context);
        if (elements.isEmpty()) {
            List<PsiElement> list = elements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        PsiFile file2 = elements.get(0).getContainingFile();
        if (file2 == null) {
            List<PsiElement> list = elements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        PsiElement last = elements.get(elements.size() - 1);
        Pattern[] patterns = new Pattern[applicablePrefixes.length];
        for (int i2 = 0; i2 < applicablePrefixes.length; ++i2) {
            String s = StructuralSearchUtil.shieldSpecialChars(applicablePrefixes[i2]);
            patterns[i2] = Pattern.compile(s + "\\w+\\b");
        }
        int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file2, patterns);
        int patternEndOffset = last.getTextRange().getEndOffset();
        if (elements.size() == 0 || PatternCompiler.checkErrorElements((PsiElement)file2, patternEndOffset, patternEndOffset, varEndOffsets, true) != Boolean.TRUE) {
            List<PsiElement> list = elements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        int varCount = varEndOffsets.length;
        String[] prefixSequence = new String[varCount];
        for (int i3 = 0; i3 < varCount; ++i3) {
            prefixSequence[i3] = applicablePrefixes[0];
        }
        List<PsiElement> finalElements = PatternCompiler.compileByPrefixes(project2, options, pattern, context, applicablePrefixes, patterns, prefixSequence, 0);
        List<PsiElement> list = finalElements != null ? finalElements : PatternCompiler.doCompile(project2, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
        }
        return list;
    }

    @Nullable
    private static List<PsiElement> compileByPrefixes(Project project2, MatchOptions options, CompiledPattern pattern, CompileContext context, String[] applicablePrefixes, Pattern[] substitutionPatterns, String[] prefixSequence, int index) {
        if (index >= prefixSequence.length) {
            List<PsiElement> elements = PatternCompiler.doCompile(project2, options, pattern, new ArrayPrefixProvider(prefixSequence), context);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiElement parent = elements.get(0).getParent();
            PsiElement last = elements.get(elements.size() - 1);
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(parent.getContainingFile(), substitutionPatterns);
            int patternEndOffset = last.getTextRange().getEndOffset();
            return PatternCompiler.checkErrorElements(parent, patternEndOffset, patternEndOffset, varEndOffsets, false) != Boolean.TRUE ? elements : null;
        }
        String[] alternativeVariant = null;
        String[] stringArray = applicablePrefixes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            List<PsiElement> finalElements;
            int patternEndOffset;
            String applicablePrefix;
            prefixSequence[index] = applicablePrefix = stringArray[j];
            List<PsiElement> elements = PatternCompiler.doCompile(project2, options, pattern, new ArrayPrefixProvider(prefixSequence), context);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiFile file2 = elements.get(0).getContainingFile();
            if (file2 == null) {
                return elements;
            }
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file2, substitutionPatterns);
            int offset = varEndOffsets[index];
            Boolean result2 = PatternCompiler.checkErrorElements((PsiElement)file2, offset, patternEndOffset = elements.get(elements.size() - 1).getTextRange().getEndOffset(), varEndOffsets, false);
            if (result2 == Boolean.TRUE || result2 != Boolean.FALSE && (result2 != null || alternativeVariant != null) || (finalElements = PatternCompiler.compileByPrefixes(project2, options, pattern, context, applicablePrefixes, substitutionPatterns, prefixSequence, index + 1)) == null) continue;
            if (result2 == Boolean.FALSE) {
                return finalElements;
            }
            alternativeVariant = new String[prefixSequence.length];
            System.arraycopy(prefixSequence, 0, alternativeVariant, 0, prefixSequence.length);
        }
        return alternativeVariant != null ? PatternCompiler.compileByPrefixes(project2, options, pattern, context, applicablePrefixes, substitutionPatterns, alternativeVariant, index + 1) : null;
    }

    @NotNull
    private static int[] findAllTypedVarOffsets(PsiFile file2, final Pattern[] substitutionPatterns) {
        final TIntHashSet result2 = new TIntHashSet();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof LeafElement) {
                    String text = element.getText();
                    for (Pattern pattern : substitutionPatterns) {
                        Matcher matcher = pattern.matcher(text);
                        while (matcher.find()) {
                            result2.add(element.getTextRange().getStartOffset() + matcher.end());
                        }
                    }
                }
            }
        });
        int[] resultArray = result2.toArray();
        Arrays.sort(resultArray);
        if (resultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "findAllTypedVarOffsets"));
        }
        return resultArray;
    }

    @Nullable
    private static Boolean checkErrorElements(PsiElement element, final int offset, final int patternEndOffset, int[] varEndOffsets, final boolean strict) {
        final TIntArrayList errorOffsets = new TIntArrayList();
        final boolean[] containsErrorTail = new boolean[]{false};
        final TIntHashSet varEndOffsetsSet = new TIntHashSet(varEndOffsets);
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                super.visitErrorElement(element);
                int startOffset = element.getTextRange().getStartOffset();
                if ((strict || !varEndOffsetsSet.contains(startOffset)) && startOffset != patternEndOffset) {
                    errorOffsets.add(startOffset);
                }
                if (startOffset == offset) {
                    containsErrorTail[0] = true;
                }
            }
        });
        for (int i2 = 0; i2 < errorOffsets.size(); ++i2) {
            int errorOffset = errorOffsets.get(i2);
            if (errorOffset > offset) continue;
            return true;
        }
        return containsErrorTail[0] ? null : Boolean.valueOf(false);
    }

    private static List<PsiElement> doCompile(Project project2, MatchOptions options, CompiledPattern result2, PrefixProvider prefixProvider, CompileContext context) {
        PsiElement[] matchStatements;
        result2.clearHandlers();
        context.init(result2, options, project2, options.getScope() instanceof GlobalSearchScope);
        StringBuilder buf = new StringBuilder();
        Template template = TemplateManager.getInstance(project2).createTemplate("", "", options.getSearchPattern());
        int segmentsCount = template.getSegmentsCount();
        String text = template.getTemplateText();
        buf.setLength(0);
        int prevOffset = 0;
        for (int i2 = 0; i2 < segmentsCount; ++i2) {
            MatchPredicate predicate;
            int offset = template.getSegmentOffset(i2);
            String name = template.getSegmentName(i2);
            String prefix = prefixProvider.getPrefix(i2);
            if (prefix == null) {
                throw new MalformedPatternException();
            }
            buf.append(text.substring(prevOffset, offset));
            buf.append(prefix);
            buf.append(name);
            MatchVariableConstraint constraint = options.getVariableConstraint(name);
            if (constraint == null) {
                constraint = new MatchVariableConstraint();
                constraint.setName(name);
                options.addVariableConstraint(constraint);
            }
            SubstitutionHandler handler2 = result2.createSubstitutionHandler(name, prefix + name, constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
            if (constraint.isWithinHierarchy()) {
                handler2.setSubtype(true);
            }
            if (constraint.isStrictlyWithinHierarchy()) {
                handler2.setStrictSubtype(true);
            }
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getRegExp())) {
                predicate = new RegExpPredicate(constraint.getRegExp(), options.isCaseSensitiveMatch(), name, constraint.isWholeWordsOnly(), constraint.isPartOfSearchResults());
                if (constraint.isInvertRegExp()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler2, predicate);
            }
            if (constraint.isReference()) {
                predicate = new ReferencePredicate(constraint.getNameOfReferenceVar());
                if (constraint.isInvertReference()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler2, predicate);
            }
            PatternCompiler.addExtensionPredicates(options, constraint, handler2);
            PatternCompiler.addScriptConstraint(project2, name, constraint, handler2);
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getContainsConstraint())) {
                predicate = new ContainsPredicate(name, constraint.getContainsConstraint());
                if (constraint.isInvertContainsConstraint()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler2, predicate);
            }
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) assert (false);
            prevOffset = offset;
        }
        MatchVariableConstraint constraint = options.getVariableConstraint("__context__");
        if (constraint != null) {
            SubstitutionHandler handler3 = result2.createSubstitutionHandler("__context__", "__context__", constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) {
                MatchPredicate predicate = new WithinPredicate("__context__", constraint.getWithinConstraint(), options.getFileType(), project2);
                if (constraint.isInvertWithinConstraint()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler3, predicate);
            }
            PatternCompiler.addExtensionPredicates(options, constraint, handler3);
            PatternCompiler.addScriptConstraint(project2, "__context__", constraint, handler3);
        }
        buf.append(text.substring(prevOffset, text.length()));
        try {
            matchStatements = MatcherImplUtil.createTreeFromText(buf.toString(), PatternTreeContext.Block, options.getFileType(), options.getDialect(), options.getPatternContext(), project2, false);
            if (matchStatements.length == 0) {
                throw new MalformedPatternException();
            }
        }
        catch (IncorrectOperationException e) {
            throw new MalformedPatternException(e.getMessage());
        }
        NodeFilter filter = LexicalNodesFilter.getInstance();
        GlobalCompilingVisitor compilingVisitor = new GlobalCompilingVisitor();
        compilingVisitor.compile(matchStatements, context);
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (PsiElement matchStatement : matchStatements) {
            if (filter.accepts(matchStatement)) continue;
            elements.add(matchStatement);
        }
        new DeleteNodesAction(compilingVisitor.getLexicalNodes()).run();
        return elements;
    }

    private static void addExtensionPredicates(MatchOptions options, MatchVariableConstraint constraint, SubstitutionHandler handler2) {
        LinkedHashSet<MatchPredicate> predicates = new LinkedHashSet<MatchPredicate>();
        for (MatchPredicateProvider matchPredicateProvider : (MatchPredicateProvider[])Extensions.getExtensions(MatchPredicateProvider.EP_NAME)) {
            matchPredicateProvider.collectPredicates(constraint, handler2.getName(), options, predicates);
        }
        for (MatchPredicate matchPredicate : predicates) {
            PatternCompiler.addPredicate(handler2, matchPredicate);
        }
    }

    private static void addScriptConstraint(Project project2, String name, MatchVariableConstraint constraint, SubstitutionHandler handler2) {
        if (constraint.getScriptCodeConstraint() != null && constraint.getScriptCodeConstraint().length() > 2) {
            String script = StringUtil.stripQuotesAroundValue((String)constraint.getScriptCodeConstraint());
            String s = ScriptSupport.checkValidScript(script);
            if (s != null) {
                throw new MalformedPatternException("Script constraint for " + constraint.getName() + " has problem " + s);
            }
            ScriptPredicate predicate = new ScriptPredicate(project2, name, script);
            PatternCompiler.addPredicate(handler2, predicate);
        }
    }

    private static void addPredicate(SubstitutionHandler handler2, MatchPredicate predicate) {
        if (handler2.getPredicate() == null) {
            handler2.setPredicate(predicate);
        } else {
            handler2.setPredicate(new BinaryPredicate(handler2.getPredicate(), predicate, false));
        }
    }

    private static class ArrayPrefixProvider
    implements PrefixProvider {
        private final String[] myPrefixes;

        private ArrayPrefixProvider(String[] prefixes) {
            this.myPrefixes = prefixes;
        }

        @Override
        public String getPrefix(int varIndex) {
            if (varIndex >= this.myPrefixes.length) {
                return null;
            }
            return this.myPrefixes[varIndex];
        }
    }

    private static class ConstantPrefixProvider
    implements PrefixProvider {
        private final String myPrefix;

        private ConstantPrefixProvider(String prefix) {
            this.myPrefix = prefix;
        }

        @Override
        public String getPrefix(int varIndex) {
            return this.myPrefix;
        }
    }

    private static interface PrefixProvider {
        public String getPrefix(int var1);
    }
}

