/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.intention.impl.SplitDeclarationAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class TypeMigrationStatementProcessor
extends JavaRecursiveElementVisitor {
    private final PsiElement myStatement;
    private final TypeMigrationLabeler myLabeler;
    private static final Logger LOG = Logger.getInstance((String)("#" + TypeMigrationStatementProcessor.class.getName()));
    private final TypeEvaluator myTypeEvaluator;

    public TypeMigrationStatementProcessor(PsiElement expression, TypeMigrationLabeler labeler) {
        this.myStatement = expression;
        this.myLabeler = labeler;
        this.myTypeEvaluator = this.myLabeler.getTypeEvaluator();
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        IElementType binaryOperator;
        super.visitAssignmentExpression(expression);
        PsiExpression lExpression = expression.getLExpression();
        TypeView left = new TypeView(lExpression);
        PsiExpression rExpression = expression.getRExpression();
        if (rExpression == null) {
            return;
        }
        TypeView right = new TypeView(rExpression);
        IElementType sign = expression.getOperationTokenType();
        PsiType ltype = left.getType();
        PsiType rtype = right.getType();
        if (ltype == null || rtype == null) {
            return;
        }
        if (sign != JavaTokenType.EQ && !TypeConversionUtil.isBinaryOperatorApplicable((IElementType)(binaryOperator = TypeConversionUtil.convertEQtoOperation((IElementType)sign)), (PsiType)ltype, (PsiType)rtype, (boolean)false)) {
            if (left.isChanged()) {
                this.findConversionOrFail((PsiExpression)expression, lExpression, left.getTypePair());
            }
            if (right.isChanged()) {
                this.findConversionOrFail((PsiExpression)expression, rExpression, right.getTypePair());
            }
            return;
        }
        switch (TypeInfection.getInfection(left, right)) {
            case 0: {
                break;
            }
            case 1: {
                this.myLabeler.migrateExpressionType(rExpression, ltype, this.myStatement, TypeConversionUtil.isAssignable((PsiType)ltype, (PsiType)rtype) && !TypeMigrationStatementProcessor.isSetter(expression), true);
                break;
            }
            case 2: {
                if (lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() instanceof PsiLocalVariable && !TypeMigrationStatementProcessor.canBeVariableType(rtype)) {
                    this.tryToRemoveLocalVariableAssignment((PsiLocalVariable)((PsiReferenceExpression)lExpression).resolve(), rExpression, rtype);
                    break;
                }
                this.myLabeler.migrateExpressionType(lExpression, rtype, this.myStatement, TypeConversionUtil.isAssignable((PsiType)ltype, (PsiType)rtype), false);
                break;
            }
            case 3: {
                this.addTypeUsage((PsiElement)lExpression);
                this.addTypeUsage((PsiElement)rExpression);
                break;
            }
            default: {
                LOG.error("Must not happen.");
            }
        }
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        TypeView typeView;
        super.visitArrayAccessExpression(expression);
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            this.checkIndexExpression(indexExpression);
        }
        if ((typeView = new TypeView(expression.getArrayExpression())).isChanged() && typeView.getType() instanceof PsiClassType) {
            TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typeView.getTypePair().first, typeView.getType(), null, (PsiExpression)expression, false, this.myLabeler);
            if (conversion == null) {
                this.myLabeler.markFailedConversion(typeView.getTypePair(), (PsiExpression)expression);
            } else {
                this.myLabeler.setConversionMapping((PsiExpression)expression, conversion);
                this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression), this.myTypeEvaluator.evaluateType((PsiExpression)expression));
            }
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement2) {
        PsiSwitchStatement switchStatement;
        TypeView typeView;
        super.visitSwitchLabelStatement(statement2);
        PsiExpression caseValue = statement2.getCaseValue();
        if (caseValue != null && (typeView = new TypeView(caseValue)).isChanged() && (switchStatement = statement2.getEnclosingSwitchStatement()) != null) {
            PsiExpression expression = switchStatement.getExpression();
            this.myLabeler.migrateExpressionType(expression, typeView.getType(), this.myStatement, false, false);
        }
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        super.visitInstanceOfExpression(expression);
        PsiTypeElement typeElement = expression.getCheckType();
        if (typeElement != null) {
            PsiExpression consideredExpression = expression.getOperand();
            PsiType migrationType = this.myTypeEvaluator.evaluateType(consideredExpression);
            PsiType fixedType = typeElement.getType();
            if (migrationType != null && !TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)fixedType)) {
                this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)fixedType, (Object)migrationType), consideredExpression);
            }
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        super.visitTypeCastExpression(expression);
        PsiTypeElement typeElement = expression.getCastType();
        if (typeElement != null) {
            PsiType fixedType = typeElement.getType();
            PsiType migrationType = this.myTypeEvaluator.evaluateType(expression.getOperand());
            if (migrationType != null && !TypeConversionUtil.areTypesConvertible((PsiType)migrationType, (PsiType)fixedType)) {
                this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)fixedType, (Object)migrationType), (PsiExpression)expression);
            }
        }
    }

    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && initializer.getType() != null) {
            this.processVariable(variable, initializer, null, null, null, false);
        }
    }

    public void visitReturnStatement(PsiReturnStatement statement2) {
        super.visitReturnStatement(statement2);
        PsiElement method2 = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        PsiExpression value = statement2.getReturnValue();
        if (method2 != null && value != null) {
            if (method2 instanceof PsiLambdaExpression) {
                return;
            }
            PsiType returnType = ((PsiMethod)method2).getReturnType();
            PsiType valueType = this.myTypeEvaluator.evaluateType(value);
            if (returnType != null && valueType != null && !this.myLabeler.addMigrationRoot(method2, valueType, this.myStatement, TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)valueType) && !TypeMigrationStatementProcessor.isGetter(value, method2), true, true) && TypeMigrationLabeler.typeContainsTypeParameters(returnType, Collections.emptySet())) {
                value.accept((PsiElementVisitor)this);
            }
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null && qualifierExpression.isPhysical()) {
            qualifierExpression.accept((PsiElementVisitor)this);
            TypeView qualifierView = new TypeView(qualifierExpression);
            if (qualifierView.isChanged()) {
                PsiMember member = (PsiMember)expression.advancedResolve(false).getElement();
                if (member == null) {
                    return;
                }
                Pair<PsiType, PsiType> typePair = qualifierView.getTypePair();
                TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), member, (PsiExpression)expression, false, this.myLabeler);
                if (conversion == null) {
                    this.myLabeler.markFailedConversion(typePair, qualifierExpression);
                } else {
                    PsiElement parent = Util.getEssentialParent((PsiElement)expression);
                    PsiType type = conversion.conversionType();
                    if (parent instanceof PsiMethodCallExpression) {
                        this.myLabeler.setConversionMapping((PsiExpression)((PsiMethodCallExpression)parent), conversion);
                        this.myTypeEvaluator.setType(new TypeMigrationUsageInfo(parent), type != null ? type : this.myTypeEvaluator.evaluateType((PsiExpression)parent));
                    } else {
                        this.myLabeler.setConversionMapping((PsiExpression)expression, conversion);
                        this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression), type != null ? type : this.myTypeEvaluator.evaluateType((PsiExpression)expression));
                    }
                }
            }
        }
    }

    public void visitIfStatement(PsiIfStatement statement2) {
        TypeView view;
        super.visitIfStatement(statement2);
        PsiExpression condition = statement2.getCondition();
        if (condition != null && (view = new TypeView(condition)).isChanged()) {
            this.findConversionOrFail(condition, condition, view.getTypePair());
        }
    }

    public void visitForeachStatement(PsiForeachStatement statement2) {
        super.visitForeachStatement(statement2);
        PsiExpression value = statement2.getIteratedValue();
        PsiParameter psiParameter = statement2.getIterationParameter();
        if (value != null) {
            TypeView typeView = new TypeView(value);
            PsiType psiType = typeView.getType();
            if (psiType instanceof PsiArrayType) {
                psiType = ((PsiArrayType)psiType).getComponentType();
            } else if (psiType instanceof PsiClassType) {
                PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiType).resolveGenerics();
                PsiClass psiClass = resolveResult.getElement();
                PsiType targetTypeParameter = this.getTargetTypeParameter(psiClass, value, typeView);
                if (targetTypeParameter == null) {
                    return;
                }
                psiType = resolveResult.getSubstitutor().substitute(targetTypeParameter);
                if (psiType instanceof PsiWildcardType) {
                    psiType = ((PsiWildcardType)psiType).getExtendsBound();
                }
            } else {
                return;
            }
            TypeView left = new TypeView((PsiVariable)psiParameter, null, null);
            if (TypeInfection.getInfection(left, typeView) == 1) {
                PsiArrayType iterableType;
                PsiType typeViewType = typeView.getType();
                if (typeViewType instanceof PsiArrayType) {
                    iterableType = left.getType().createArrayType();
                } else {
                    PsiClass iterableClass = PsiUtil.resolveClassInType((PsiType)typeViewType);
                    LOG.assertTrue(iterableClass != null);
                    PsiType targetType = this.getTargetTypeParameter(iterableClass, value, typeView);
                    PsiClass typeParam = PsiUtil.resolveClassInClassTypeOnly((PsiType)targetType);
                    if (!(typeParam instanceof PsiTypeParameter)) {
                        return;
                    }
                    Map<PsiTypeParameter, PsiType> substMap = Collections.singletonMap((PsiTypeParameter)typeParam, left.getType());
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)iterableClass.getProject());
                    iterableType = factory.createType(iterableClass, factory.createSubstitutor(substMap));
                }
                this.myLabeler.migrateExpressionType(value, (PsiType)iterableType, this.myStatement, TypeConversionUtil.isAssignable((PsiType)iterableType, (PsiType)typeViewType), true);
            } else {
                this.processVariable((PsiVariable)psiParameter, value, psiType, null, null, false);
            }
        }
    }

    private PsiType getTargetTypeParameter(PsiClass iterableClass, PsiExpression value, TypeView typeView) {
        Project project2 = iterableClass.getProject();
        PsiClass itClass = JavaPsiFacade.getInstance((Project)project2).findClass("java.lang.Iterable", GlobalSearchScope.allScope((Project)project2));
        if (itClass == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)iterableClass, (PsiClass)itClass, (boolean)true)) {
            this.findConversionOrFail(value, value, typeView.getTypePair());
            return null;
        }
        PsiSubstitutor aSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)itClass, (PsiClass)iterableClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return aSubstitutor.substitute(itClass.getTypeParameters()[0]);
    }

    public void visitNewExpression(PsiNewExpression expression) {
        PsiExpression[] dimensions;
        super.visitNewExpression(expression);
        for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
            this.checkIndexExpression(dimension);
        }
        PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
        if (arrayInitializer != null) {
            this.processArrayInitializer(arrayInitializer, (PsiExpression)expression);
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        super.visitArrayInitializerExpression(expression);
        this.processArrayInitializer(expression, (PsiExpression)expression);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        this.processUnaryExpression((PsiExpression)expression, expression.getOperationSign());
    }

    public void visitPrefixExpression(PsiPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        this.processUnaryExpression((PsiExpression)expression, expression.getOperationSign());
    }

    private void processUnaryExpression(PsiExpression expression, PsiJavaToken sign) {
        TypeView typeView = new TypeView(expression);
        if (typeView.isChanged() && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)sign, (PsiType)typeView.getType())) {
            this.findConversionOrFail(expression, expression, typeView.getTypePair());
        }
    }

    private void findConversionOrFail(PsiExpression expression, PsiExpression toFail, Pair<PsiType, PsiType> typePair) {
        TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), null, expression, this.myLabeler);
        if (conversion == null) {
            this.myLabeler.markFailedConversion(typePair, toFail);
        } else {
            this.myLabeler.setConversionMapping(expression, conversion);
            PsiType psiType = this.myTypeEvaluator.evaluateType(expression);
            LOG.assertTrue(psiType != null, (Object)expression);
            this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression), psiType);
        }
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        super.visitPolyadicExpression(expression);
        PsiExpression[] operands = expression.getOperands();
        if (operands.length == 0) {
            return;
        }
        IElementType operationTokenType = expression.getOperationTokenType();
        PsiExpression lOperand = operands[0];
        TypeView left = new TypeView(lOperand);
        for (int i2 = 1; i2 < operands.length; ++i2) {
            PsiExpression rOperand = operands[i2];
            if (rOperand == null) {
                return;
            }
            TypeView right = new TypeView(rOperand);
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationTokenType, (PsiType)left.getType(), (PsiType)right.getType(), (boolean)false)) {
                if (left.isChanged()) {
                    this.findConversionOrFail(lOperand, lOperand, left.getTypePair());
                }
                if (right.isChanged()) {
                    this.findConversionOrFail(rOperand, rOperand, right.getTypePair());
                }
            }
            lOperand = rOperand;
            left = right;
        }
    }

    private void processArrayInitializer(PsiArrayInitializerExpression expression, PsiExpression parentExpression) {
        PsiExpression[] initializers = expression.getInitializers();
        PsiType migrationType = null;
        for (PsiExpression initializer : initializers) {
            TypeView typeView = new TypeView(initializer);
            if (!typeView.isChanged()) continue;
            PsiType type = typeView.getType();
            if (migrationType != null && TypeConversionUtil.isAssignable(migrationType, (PsiType)type)) continue;
            if (migrationType != null && !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)migrationType)) {
                this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)parentExpression.getType(), (Object)type), parentExpression);
                return;
            }
            migrationType = type;
        }
        PsiType exprType = expression.getType();
        if (migrationType != null && exprType instanceof PsiArrayType) {
            boolean alreadyProcessed = TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)exprType).getComponentType(), migrationType);
            this.myLabeler.migrateExpressionType(parentExpression, (PsiType)(alreadyProcessed ? exprType : migrationType.createArrayType()), (PsiElement)expression, alreadyProcessed, true);
        }
    }

    private void checkIndexExpression(PsiExpression indexExpression) {
        PsiType indexType = this.myTypeEvaluator.evaluateType(indexExpression);
        if (indexType != null && !TypeConversionUtil.isAssignable((PsiType)PsiType.INT, (PsiType)indexType)) {
            this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)indexExpression.getType(), (Object)indexType), indexExpression);
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
        super.visitMethodCallExpression(methodCallExpression);
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiElement method2 = resolveResult.getElement();
        if (method2 instanceof PsiMethod) {
            PsiType qualifierType;
            if (this.migrateEqualsMethod(methodCallExpression, (PsiMethod)method2)) {
                return;
            }
            PsiExpression[] psiExpressions = methodCallExpression.getArgumentList().getExpressions();
            PsiParameter[] originalParams = ((PsiMethod)method2).getParameterList().getParameters();
            PsiSubstitutor evalSubstitutor = this.myTypeEvaluator.createMethodSubstitution(originalParams, psiExpressions, (PsiMethod)method2, (PsiExpression)methodCallExpression);
            for (int i2 = 0; i2 < psiExpressions.length; ++i2) {
                PsiParameter originalParameter;
                if (originalParams.length <= i2) {
                    if (originalParams.length <= 0 || !originalParams[originalParams.length - 1].isVarArgs()) continue;
                    originalParameter = originalParams[originalParams.length - 1];
                } else {
                    originalParameter = originalParams[i2];
                }
                this.processVariable((PsiVariable)originalParameter, psiExpressions[i2], null, resolveResult.getSubstitutor(), evalSubstitutor, true);
            }
            PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
            if (qualifier != null && qualifier.isPhysical() && !new TypeView(qualifier).isChanged() && (qualifierType = qualifier.getType()) instanceof PsiClassType) {
                PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)qualifierType).resolveGenerics();
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myStatement.getProject());
                PsiClassType migrationType = elementFactory.createType(classResolveResult.getElement(), TypeMigrationStatementProcessor.composeIfNotAssignable(classResolveResult.getSubstitutor(), evalSubstitutor));
                this.myLabeler.migrateExpressionType(qualifier, (PsiType)migrationType, this.myStatement, migrationType.equals(qualifierType), true);
            }
        }
    }

    private boolean migrateEqualsMethod(PsiMethodCallExpression methodCallExpression, PsiMethod method2) {
        PsiParameter parameter;
        PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        TypeView qualifierTypeView = new TypeView(qualifier);
        if (!qualifierTypeView.isChanged()) {
            return false;
        }
        if (method2.getName().equals("equals") && method2.getParameterList().getParametersCount() == 1 && (parameter = method2.getParameterList().getParameters()[0]).getType().equals(PsiType.getJavaLangObject((PsiManager)methodCallExpression.getManager(), (GlobalSearchScope)methodCallExpression.getResolveScope()))) {
            PsiExpression[] expressions = methodCallExpression.getArgumentList().getExpressions();
            if (expressions.length != 1) {
                return false;
            }
            TypeView argumentTypeView = new TypeView(expressions[0]);
            PsiType argumentType = argumentTypeView.getType();
            if (!argumentTypeView.isChanged() && ((PsiType)qualifierTypeView.getTypePair().getFirst()).equals(argumentType)) {
                PsiType migrationType = qualifierTypeView.getType();
                this.myLabeler.migrateExpressionType(expressions[0], migrationType, (PsiElement)methodCallExpression, TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)argumentType), true);
                return true;
            }
        }
        return false;
    }

    private void processVariable(PsiVariable variable, PsiExpression value, PsiType migrationType, PsiSubstitutor varSubstitutor, PsiSubstitutor evalSubstitutor, boolean isCovariantPosition) {
        TypeView right = new TypeView(value);
        TypeView left = new TypeView(variable, varSubstitutor, evalSubstitutor);
        PsiType declarationType = left.getType();
        switch (TypeInfection.getInfection(left, right)) {
            case 0: {
                break;
            }
            case 1: {
                PsiType valueType = right.getType();
                if (valueType == null || declarationType == null) break;
                this.myLabeler.migrateExpressionType(value, TypeMigrationStatementProcessor.adjustMigrationTypeIfGenericArrayCreation(declarationType, value), this.myStatement, TypeConversionUtil.isAssignable((PsiType)declarationType, (PsiType)valueType), true);
                break;
            }
            case 2: {
                PsiDeclarationStatement decl;
                PsiType psiType;
                PsiType psiType2 = psiType = migrationType != null ? migrationType : right.getType();
                if (psiType == null) break;
                if (TypeMigrationStatementProcessor.canBeVariableType(psiType)) {
                    if (declarationType == null || this.myLabeler.addMigrationRoot((PsiElement)variable, psiType, this.myStatement, TypeConversionUtil.isAssignable((PsiType)declarationType, (PsiType)psiType), true) || TypeConversionUtil.isAssignable((PsiType)left.getType(), (PsiType)psiType)) break;
                    PsiType initialType = left.getType();
                    if (initialType instanceof PsiEllipsisType) {
                        initialType = ((PsiEllipsisType)initialType).getComponentType();
                    }
                    this.myLabeler.convertExpression(value, psiType, initialType, isCovariantPosition);
                    break;
                }
                if (!(variable instanceof PsiLocalVariable) || (decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class)) == null || decl.getDeclaredElements().length != 1) break;
                this.tryToRemoveLocalVariableAssignment((PsiLocalVariable)variable, value, psiType);
                break;
            }
            case 3: {
                this.addTypeUsage((PsiElement)variable);
                break;
            }
            default: {
                LOG.error("Must not happen.");
            }
        }
    }

    private void tryToRemoveLocalVariableAssignment(@NotNull PsiLocalVariable variable, @NotNull PsiExpression valueExpression, @NotNull PsiType migrationType) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor", "tryToRemoveLocalVariableAssignment"));
        }
        if (valueExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExpression", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor", "tryToRemoveLocalVariableAssignment"));
        }
        if (migrationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "migrationType", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor", "tryToRemoveLocalVariableAssignment"));
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        PsiElement[] refs = DefUseUtil.getRefs(codeBlock, (PsiVariable)variable, (PsiElement)valueExpression);
        if (refs.length == 0) {
            this.myLabeler.setConversionMapping(valueExpression, new TypeConversionDescriptorBase(){

                @Override
                public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    if (evaluator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor$1", "replace"));
                    }
                    PsiElement parent = expression.getParent();
                    if (parent instanceof PsiLocalVariable) {
                        PsiLocalVariable var = (PsiLocalVariable)parent;
                        PsiDeclarationStatement decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)var, PsiDeclarationStatement.class);
                        if (decl == null) {
                            return null;
                        }
                        Project project2 = var.getProject();
                        PsiAssignmentExpression assignment = SplitDeclarationAction.invokeOnDeclarationStatement(decl, PsiManager.getInstance((Project)project2), project2);
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression == null) {
                            return null;
                        }
                        assignment.replace((PsiElement)rExpression);
                        if (ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).forEach((Processor)new CommonProcessors.FindFirstProcessor())) {
                            var.delete();
                        }
                    } else if (parent instanceof PsiAssignmentExpression) {
                        PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
                        return rExpression == null ? null : (PsiExpression)parent.replace((PsiElement)rExpression);
                    }
                    return null;
                }
            });
        } else {
            this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.pair(null, (Object)migrationType), valueExpression);
        }
    }

    private static boolean canBeVariableType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor", "canBeVariableType"));
        }
        return !type.getDeepComponentType().equals(PsiType.VOID);
    }

    private static PsiType adjustMigrationTypeIfGenericArrayCreation(PsiType migrationType, PsiExpression expression) {
        PsiClassType rawType;
        PsiType componentType;
        if (expression instanceof PsiNewExpression && migrationType instanceof PsiArrayType && (componentType = migrationType.getDeepComponentType()) instanceof PsiClassType && !(rawType = ((PsiClassType)componentType).rawType()).equals((Object)componentType)) {
            return com.intellij.refactoring.typeCook.Util.createArrayType((PsiType)rawType, migrationType.getArrayDimensions());
        }
        return migrationType;
    }

    private void addTypeUsage(PsiElement typedElement) {
        if (typedElement instanceof PsiReferenceExpression) {
            this.myLabeler.setTypeUsage(((PsiReferenceExpression)typedElement).resolve(), this.myStatement);
        } else if (typedElement instanceof PsiMethodCallExpression) {
            this.myLabeler.setTypeUsage((PsiElement)((PsiMethodCallExpression)typedElement).resolveMethod(), this.myStatement);
        } else {
            this.myLabeler.setTypeUsage(typedElement, this.myStatement);
        }
    }

    private static boolean isSetter(PsiAssignmentExpression expression) {
        PsiElement resolved;
        PsiExpression lExpression = expression.getLExpression();
        if (lExpression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField) {
            PsiMethod setter;
            PsiField field = (PsiField)resolved;
            NavigatablePsiElement containingMethod = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (containingMethod instanceof PsiMethod && containingMethod.isEquivalentTo((PsiElement)(setter = PropertyUtil.findPropertySetter((PsiClass)field.getContainingClass(), (String)field.getName(), (boolean)field.hasModifierProperty("static"), (boolean)false)))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isGetter(PsiExpression returnValue, PsiElement containingMethod) {
        PsiElement resolved;
        if (returnValue instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            boolean isStatic = field.hasModifierProperty("static");
            PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters(field.getContainingClass(), field.getName(), isStatic);
            if (getters != null) {
                for (PsiMethod getter : getters) {
                    if (!containingMethod.isEquivalentTo((PsiElement)getter)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiSubstitutor composeIfNotAssignable(PsiSubstitutor actual, PsiSubstitutor required) {
        if (actual == PsiSubstitutor.EMPTY) {
            return required;
        }
        if (required == PsiSubstitutor.EMPTY) {
            return actual;
        }
        PsiSubstitutor result2 = PsiSubstitutorImpl.createSubstitutor(actual.getSubstitutionMap());
        for (Map.Entry e : required.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)e.getKey();
            PsiType requiredType = (PsiType)e.getValue();
            PsiType actualType = (PsiType)result2.getSubstitutionMap().get(typeParameter);
            if (requiredType == null || actualType != null && TypeConversionUtil.isAssignable((PsiType)actualType, (PsiType)requiredType)) continue;
            result2 = result2.put(typeParameter, requiredType);
        }
        return result2;
    }

    private static class TypeInfection {
        static final int NONE_INFECTED = 0;
        static final int LEFT_INFECTED = 1;
        static final int RIGHT_INFECTED = 2;
        static final int BOTH_INFECTED = 3;

        private TypeInfection() {
        }

        static int getInfection(TypeView left, TypeView right) {
            return (left.isChanged() ? 1 : 0) + (right.isChanged() ? 2 : 0);
        }
    }

    private class TypeView {
        final PsiType myOriginType;
        final PsiType myType;
        final boolean myChanged;

        public TypeView(PsiExpression expr) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor$TypeView", "<init>"));
            }
            PsiType exprType = expr.getType();
            exprType = exprType instanceof PsiEllipsisType ? ((PsiEllipsisType)exprType).toArrayType() : exprType;
            this.myOriginType = GenericsUtil.getVariableTypeByExpressionType((PsiType)exprType);
            PsiType type = TypeMigrationStatementProcessor.this.myTypeEvaluator.evaluateType(expr);
            type = type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type;
            this.myType = GenericsUtil.getVariableTypeByExpressionType((PsiType)type);
            this.myChanged = this.myOriginType == null || this.myType == null ? false : !this.myType.equals(this.myOriginType);
        }

        public TypeView(PsiVariable var, PsiSubstitutor varSubstitutor, PsiSubstitutor evalSubstitutor) {
            this.myOriginType = varSubstitutor != null ? varSubstitutor.substitute(var.getType()) : var.getType();
            HashMap realMap = new HashMap();
            if (varSubstitutor != null) {
                realMap.putAll(varSubstitutor.getSubstitutionMap());
            }
            if (evalSubstitutor != null) {
                realMap.putAll(evalSubstitutor.getSubstitutionMap());
            }
            this.myType = PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)realMap).substitute(TypeMigrationStatementProcessor.this.myTypeEvaluator.getType((PsiElement)var));
            this.myChanged = this.myOriginType == null || this.myType == null ? false : !this.myType.equals(this.myOriginType);
        }

        public PsiType getType() {
            return this.myType;
        }

        public boolean isChanged() {
            return this.myChanged;
        }

        public Pair<PsiType, PsiType> getTypePair() {
            return Pair.create((Object)this.myOriginType, (Object)this.myType);
        }
    }
}

