/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RelatedFilesRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelatedFilesRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RelatedFilesRenamerFactory", "isApplicable"));
        }
        return element instanceof PsiFile && ((PsiFile)element).getVirtualFile() != null && !NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), ((PsiFile)element).getVirtualFile()).isEmpty();
    }

    @Override
    @Nullable
    public String getOptionName() {
        return "Rename related files (with the same name)";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element, @NotNull String newName, @NotNull Collection<UsageInfo> usages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RelatedFilesRenamerFactory", "createRenamer"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/RelatedFilesRenamerFactory", "createRenamer"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/rename/RelatedFilesRenamerFactory", "createRenamer"));
        }
        RelatedFilesRenamer relatedFilesRenamer = new RelatedFilesRenamer((PsiFile)element, newName);
        if (relatedFilesRenamer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RelatedFilesRenamerFactory", "createRenamer"));
        }
        return relatedFilesRenamer;
    }
}

