/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MutationUtils {
    private MutationUtils() {
    }

    public static void replaceType(@NotNull String newTypeText, @NotNull PsiTypeElement typeElement) throws IncorrectOperationException {
        if (newTypeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeText", "com/intellij/refactoring/psi/MutationUtils", "replaceType"));
        }
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/refactoring/psi/MutationUtils", "replaceType"));
        }
        Project project2 = typeElement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiType newType = factory.createTypeFromText(newTypeText, null);
        PsiTypeElement newTypeElement = factory.createTypeElement(newType);
        PsiElement insertedElement = typeElement.replace((PsiElement)newTypeElement);
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project2).reformat(shortenedElement);
    }

    public static void replaceExpression(@NotNull String newExpression, @NotNull PsiExpression exp) throws IncorrectOperationException {
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/intellij/refactoring/psi/MutationUtils", "replaceExpression"));
        }
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/intellij/refactoring/psi/MutationUtils", "replaceExpression"));
        }
        Project project2 = exp.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiExpression newCall = factory.createExpressionFromText(newExpression, null);
        PsiElement insertedElement = exp.replace((PsiElement)newCall);
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project2).reformat(shortenedElement);
    }

    public static void replaceExpressionIfValid(@NotNull String newExpression, @NotNull PsiExpression exp) throws IncorrectOperationException {
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/intellij/refactoring/psi/MutationUtils", "replaceExpressionIfValid"));
        }
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/intellij/refactoring/psi/MutationUtils", "replaceExpressionIfValid"));
        }
        try {
            MutationUtils.replaceExpression(newExpression, exp);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    public static void replaceReference(@NotNull String className, @NotNull PsiJavaCodeReferenceElement ref) throws IncorrectOperationException {
        PsiElement insertedElement;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/refactoring/psi/MutationUtils", "replaceReference"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/refactoring/psi/MutationUtils", "replaceReference"));
        }
        Project project2 = ref.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = facade.getElementFactory();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiReferenceExpression) {
            PsiClass aClass = facade.findClass(className, scope);
            if (aClass == null) {
                return;
            }
            ((PsiReferenceExpression)parent).setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
            insertedElement = ((PsiReferenceExpression)parent).getQualifierExpression();
            assert (insertedElement != null) : parent;
        } else {
            PsiJavaCodeReferenceElement newReference = factory.createReferenceElementByFQClassName(className, scope);
            insertedElement = ref.replace((PsiElement)newReference);
        }
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project2).reformat(shortenedElement);
    }

    public static void replaceStatement(@NotNull String newStatement, @NotNull PsiStatement statement2) throws IncorrectOperationException {
        if (newStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatement", "com/intellij/refactoring/psi/MutationUtils", "replaceStatement"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/refactoring/psi/MutationUtils", "replaceStatement"));
        }
        Project project2 = statement2.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiStatement newCall = factory.createStatementFromText(newStatement, null);
        PsiElement insertedElement = statement2.replace((PsiElement)newCall);
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project2).reformat(shortenedElement);
    }
}

