/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.listeners.impl.impl.RefactoringTransactionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RefactoringListenerManagerImpl
extends RefactoringListenerManager {
    private final List<RefactoringElementListenerProvider> myListenerProviders = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Project myProject;

    public RefactoringListenerManagerImpl(Project project2) {
        this.myProject = project2;
    }

    public void addListenerProvider(RefactoringElementListenerProvider provider) {
        this.myListenerProviders.add(provider);
    }

    public void removeListenerProvider(RefactoringElementListenerProvider provider) {
        this.myListenerProviders.remove(provider);
    }

    public RefactoringTransaction startTransaction() {
        ArrayList<RefactoringElementListenerProvider> providers = new ArrayList<RefactoringElementListenerProvider>(this.myListenerProviders);
        Collections.addAll(providers, Extensions.getExtensions((ExtensionPointName)RefactoringElementListenerProvider.EP_NAME, (AreaInstance)this.myProject));
        return new RefactoringTransactionImpl(providers);
    }
}

